///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2004 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//          Date: 11/26/2004
//
//  Description :  OCP Channel Transaction Recording Monitor
//	  This system monitor is based on the transaction recording 
//	  API in the SystemC Verification (SCV) Library. It targets 
//	  performance analysis for architectural modeling.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _OCP_PERF_MONITOR_SYSTEM_REGISTRY_H
#define _OCP_PERF_MONITOR_SYSTEM_REGISTRY_H

#include "ocp_tl2_monitor_observer_if.h"

#include "ocp_perf_monitor_system_scv.h"

template <class Tdata, class Taddr>
class OCP_Perf_Monitor_System_Registry
{
public:
  typedef OCP_TL2_Monitor_ObserverIF<Tdata,Taddr> monitor_type;

  // singleton
  static monitor_type* instance() {
    if (!m_instance) {
      //m_instance = new OCP_Perf_Monitor_System_SCV<Tdata,Taddr>(true);
      m_instance = new OCP_Perf_Monitor_System_SCV<Tdata,Taddr>(false);
    }
    return m_instance; 
  }
  static void delete_system_monitor() {
    if (m_instance) {
      delete m_instance;
      m_instance = NULL;
    }
  }

private:
  // disabled
  OCP_Perf_Monitor_System_Registry();

  static monitor_type* m_instance;
};

// init static member
template <class Tdata, class Taddr>
typename OCP_Perf_Monitor_System_Registry<Tdata,Taddr>::monitor_type* 
  OCP_Perf_Monitor_System_Registry<Tdata,Taddr>::m_instance = NULL;

#endif
