// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Anssi Haverinen, Nokia Inc. anssi.haverinen@nokia.com
//         Date : 03/31/2003
//
//  Description : Transaction Level - Generic data class.
//                Bare bones template for your own data class
// ============================================================================


#ifndef _TLx_DATA_CL
#define _TLx_DATA_CL

template <class Td, class Ta> class TLx_DataCl
{
public:

  typedef Td DataType;
  typedef Ta AddrType;

  // Constructor
  TLx_DataCl()
  {
  }

  // Destructor
  ~TLx_DataCl()
  {
  }



// These methods are used in the Channel,
// and hence they must always be present!

  bool IsWriteRequest()
  {
    return((ReqCmd == 1) ? true : false);
  }
  void SetWriteRequest()
  {
    ReqCmd = 1;
  }
  void SetReadRequest() 
  {
    ReqCmd = 2;
  }

  // Channel calls these methods at the beginning
  // of each transaction type. Use these for implementing
  // data protection or other interesting features

  // For response channel t-action
  void ToggleResponse() {} 
  // For first request channel t-action (command handshake)
  void ToggleRequest() {} 
  // For second request channel t-action (data handshake)
  void ToggleDataRequest() {} 

//---------------------------------------------------------------------
// -------------- Start of access methods -------------------------------

// Fill in here with your own methods  

  // Data transfer methods (pointer passing)
  void MputMData(Td* d)
  {
    ReqData = d;
  }
  void SputSData(Td* d)
  {
    ResData = d;
  }
  Td * MgetSData()
  {
    return ResData;
  }
  Td * SgetMData()
  {
    return ReqData;
  }

// -------------- End of access methods -------------------------------

// --------------- Request Channel data memebers ----------------------

  // Data pointer, contains the data in a write request
  Td *ReqData;

  // Identifies whether the Master request is a read or write request.
  int ReqCmd;

// --------------- Response Channel data memebers ---------------------

  // Data pointer, returns the data in a read request
  Td *ResData;


private:

};

#endif // _TLx_DATA_CL
