// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexandrian, Sonics
//         $Id: Slave_2d.h,v 1.1 2007/08/21 02:23:35 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================



#ifndef _SLAVE_H
#define _SLAVE_H

#include "channel_types.h"
#include "sim_params.h"

#include <map>
#include <string>

#include <systemc.h>
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_data_cl.h"
#include "ocp_tl1_channel.h"

#include "tl1_Slave.h"

#include "read_map.h"


#include "ocp_tl0_port.h"
#include "ocp2_tl0_tl1_master_adapter.h"
#include "ocp_tl1_master_port.h"

// ----------------------------------------------------------------------------
//
//  Instantiation of the master adapter template
//
// ----------------------------------------------------------------------------
template class OCP2_TL0_TL1_Master_Adapter < OCP_TL1_DataCl<DType, AType >  >;

class slave_ip_ports : public OCP2_TL0_SlavePorts {

public:

  // sc_port definitions

  sc_proxy_in_signal_port<sc_bv<3> > MCmd;
  sc_proxy_in_signal_port<sc_bv<16> > MAddr;
  sc_proxy_in_signal_port <sc_bv<32> > MData;
  sc_proxy_in_signal_port <sc_bv<4> > MByteEn;
  sc_proxy_in_signal_port <bool> MRespAccept;
  sc_proxy_out_signal_port <bool> SCmdAccept;
  sc_proxy_out_signal_port <sc_bv<2> > SResp;
  sc_proxy_out_signal_port <sc_bv<32> >SData;

  sc_proxy_in_signal_port<bool> MReqLast;
  sc_proxy_in_signal_port<bool> MReqRowLast;
  sc_proxy_in_signal_port<bool> MBurstSingleReq;
  sc_proxy_in_signal_port<unsigned int> MBurstLength;
  sc_proxy_in_signal_port<unsigned int> MBlockHeight;
  sc_proxy_in_signal_port<unsigned int> MBlockStride;
  sc_proxy_out_signal_port<bool> SRespLast;
  sc_proxy_out_signal_port<bool> SRespRowLast;

  // default constructor, names all ports
  slave_ip_ports():
    MCmd( "MCmd" ),
    MAddr( "MAddr" ),
    MData( "MData" ),
    MByteEn( "MByteEn" ),
    MRespAccept( "MRespAccept" ),
    SCmdAccept ( "SCmdAccept" ),
    SResp( "SResp" ),
    SData( "SData" ),
    MReqLast( "MReqLast" ),
    MReqRowLast( "MReqRowLast" ),
    MBurstSingleReq( "MBurstSingleReq" ),
    MBurstLength( "MBurstLength" ),
    MBlockHeight( "MBlockHeight" ),
    MBlockStride( "MBlockStride" ),
    SRespLast( "SRespLast" ),
    SRespRowLast( "SRespRowLast" )
  {}


  virtual ~slave_ip_ports() {}

  // bind ports to base interface class members
  void bind() {
      mapPort( MCmd, OCP2_TL0_SlavePorts::MCmd );
      mapPort( MAddr , OCP2_TL0_SlavePorts::MAddr );
      mapPort( MData , OCP2_TL0_SlavePorts::MData );
      mapPort( MByteEn , OCP2_TL0_SlavePorts::MByteEn );
      mapPort( MRespAccept , OCP2_TL0_SlavePorts::MRespAccept );
      mapPort( SCmdAccept , OCP2_TL0_SlavePorts::SCmdAccept );
      mapPort( SResp , OCP2_TL0_SlavePorts::SResp );
      mapPort( SData , OCP2_TL0_SlavePorts::SData );
      mapPort( MReqLast, OCP2_TL0_SlavePorts::MReqLast );
      mapPort( MReqRowLast, OCP2_TL0_SlavePorts::MReqRowLast );
      mapPort( MBurstSingleReq, OCP2_TL0_SlavePorts::MBurstSingleReq );
      mapPort( MBurstLength, OCP2_TL0_SlavePorts::MBurstLength );
      mapPort( MBlockHeight, OCP2_TL0_SlavePorts::MBlockHeight );
      mapPort( MBlockStride, OCP2_TL0_SlavePorts::MBlockStride );
      mapPort( SRespLast, OCP2_TL0_SlavePorts::SRespLast );
      mapPort( SRespRowLast, OCP2_TL0_SlavePorts::SRespRowLast );
  }
};


SC_MODULE(Slave) {

  sc_out<bool> SCmdAccept;
  sc_in<sc_bv<16> > MAddr;
  sc_in<sc_bv<32> > MData;
  sc_in<bool > MRespAccept;
  sc_in<sc_bv<32/8> > MByteEn;
  sc_out<sc_bv<2> > SResp;
  sc_out<sc_bv<32> > SData;
  sc_in<sc_bv<3> > MCmd;

  sc_in<bool> MReqLast;
  sc_in<bool> MReqRowLast;
  sc_in<bool> MBurstSingleReq;
  sc_in<unsigned int> MBurstLength;
  sc_in<unsigned int> MBlockHeight;
  sc_in<unsigned int> MBlockStride;
  sc_out<bool> SRespLast;
  sc_out<bool> SRespRowLast;

  sc_in_clk Clk;

  tl1_Slave  *slave1;
  OCP_TL1_Channel<OCP_TL1_DataCl<DType, AType > > *ocp0;
  OCP2_TL0_TL1_Master_Adapter< OCP_TL1_DataCl<DType, AType > > * ip_tl0tl1;


  Slave (sc_module_name name ) :
    sc_module( name ){




    MapStringType   ocpParamMap;
    string  ocpParamFileName = "ocpParams_2d";
    
    if ( ! ocpParamFileName.empty() ) {
      readMapFromFile(ocpParamFileName, ocpParamMap);
    }
     
    ocp0 = new OCP_TL1_Channel<OCP_TL1_DataCl<DType, AType > > ("ocp0",&Clk);
    ocp0->setConfiguration(ocpParamMap);
       
    slave1 = new tl1_Slave("slave1");

    ip_tl0tl1 = new OCP2_TL0_TL1_Master_Adapter< OCP_TL1_DataCl<DType, AType > > ( "ip_tl0tl1", OCP2_TL0_SlavePorts::Factory< slave_ip_ports >());
  

    // port binding
    slave_ip_ports& ip_tl0 = dynamic_cast<slave_ip_ports&>( ip_tl0tl1->m_tl0Ports );
    

    ip_tl0tl1->MasterP( *ocp0 ); 
    ip_tl0tl1->Clk(Clk ); 
    ip_tl0.MCmd( MCmd );
    ip_tl0.MAddr( MAddr );
    ip_tl0.MData ( MData );
    ip_tl0.MByteEn ( MByteEn );
    ip_tl0.MRespAccept ( MRespAccept );
    ip_tl0.SCmdAccept( SCmdAccept );
    ip_tl0.SResp( SResp );
    ip_tl0.SData( SData ); 

    ip_tl0.MReqLast( MReqLast );
    ip_tl0.MReqRowLast( MReqRowLast );
    ip_tl0.MBurstSingleReq( MBurstSingleReq );
    ip_tl0.MBurstLength( MBurstLength );
    ip_tl0.MBlockHeight( MBlockHeight );
    ip_tl0.MBlockStride( MBlockStride );
    ip_tl0.SRespLast( SRespLast );
    ip_tl0.SRespRowLast( SRespRowLast );
      
    slave1->ipP(*ocp0);
    slave1->Clk(Clk); 

  }

  void end_of_elaboration() { 
    // configure channels and adapters 
    ip_tl0tl1->setClockPeriod(sc_time( 10, SC_NS ) );
  }

};


#endif
