#include "StlTransfer.cc"

#define TYPE32  uint32_t
#define TYPE64  snx_uint64_t
#define TYPE128 Sonics::BigInt<128>
#define TYPE256 Sonics::BigInt<256>

template class StlParserTransferCommand<TYPE32,  TYPE32>;
template class StlParserTransferCommand<TYPE32,  TYPE64>;
template class StlParserTransferCommand<TYPE64,  TYPE32>;
template class StlParserTransferCommand<TYPE64,  TYPE64>;
template class StlParserTransferCommand<TYPE128, TYPE32>;
template class StlParserTransferCommand<TYPE128, TYPE64>;
template class StlParserTransferCommand<TYPE256, TYPE32>;
template class StlParserTransferCommand<TYPE256, TYPE64>;

#define TEMPLATE_DEF_INCLUDE
#include "StlReader.cc"

template StlTransferCommand<TYPE32,  TYPE32>
IStlReader::getTransferCommand<TYPE32,  TYPE32>() const;
template StlTransferCommand<TYPE32,  TYPE64>
IStlReader::getTransferCommand<TYPE32,  TYPE64>() const;
template StlTransferCommand<TYPE64,  TYPE32>
IStlReader::getTransferCommand<TYPE64,  TYPE32>() const;
template StlTransferCommand<TYPE64,  TYPE64>
IStlReader::getTransferCommand<TYPE64,  TYPE64>() const;
template StlTransferCommand<TYPE128,  TYPE32>
IStlReader::getTransferCommand<TYPE128, TYPE32>() const;
template StlTransferCommand<TYPE128,  TYPE64>
IStlReader::getTransferCommand<TYPE128, TYPE64>() const;
template StlTransferCommand<TYPE256,  TYPE32>
IStlReader::getTransferCommand<TYPE256, TYPE32>() const;
template StlTransferCommand<TYPE256,  TYPE64>
IStlReader::getTransferCommand<TYPE256, TYPE64>() const;

template void IStlReader::setConversionTypes<TYPE32 , TYPE32>();
template void IStlReader::setConversionTypes<TYPE32 , TYPE64>();
template void IStlReader::setConversionTypes<TYPE64 , TYPE32>();
template void IStlReader::setConversionTypes<TYPE64 , TYPE64>();
template void IStlReader::setConversionTypes<TYPE128, TYPE32>();
template void IStlReader::setConversionTypes<TYPE128, TYPE64>();
template void IStlReader::setConversionTypes<TYPE256, TYPE32>();
template void IStlReader::setConversionTypes<TYPE256, TYPE64>();
