// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Albert Chitemyan Sonics Inc. 
//                
//         $Id: 
//
//  Description : OCP API - Layer-2 Delay Example
//                Top level, synchronous Master <---> synchronous Slave
//
// ============================================================================

// Turn on user messages
//#define DEBUG_TL2

// Include SystemC
#include "systemc"

// Include OCP files
#include "ocpip.h"
// Include user-defined headers
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"
#include <stdlib.h>

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  map_string_type  ocpParamMap;
  std::string ocpParamFileName;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }

  unsigned long long seed = scv_random::pick_random_seed();
  if ( argc == 3 ) {
      char* seedArg = argv[2];
      seed = strtoull( seedArg, NULL, 10 );
  }
  scv_random::set_global_seed(seed);

  // Submodules
  Slave<32,32> sl1("sl1");
  Master<32,32> ms1("ms1");

  // Set OCP configuration
  ocpip::ocp_parameters params;
  params=create_ocp_configuration_from_map("sl1", ocpParamMap);
  sl1.tp_socket.set_ocp_config(params);
  params=create_ocp_configuration_from_map("ms1", ocpParamMap);
  ms1.ip_socket.set_ocp_config(params);

  ms1.ip_socket(sl1.tp_socket);

  // Simulator
  sc_core::sc_start();
  
  return(0);
}
