// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.cc,v 1.2 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_core::sc_module_name name_): 
  sc_core::sc_module (name_), ipP("ipPort", ocpip::ocp_master_socket_tl1<32>::mm_txn_with_data()), ongoing_req(false), resp(NULL){

  // initialize common members
  cnt = 0;
  addr = 0;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  localData=0;
  rspcnt=0;
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if channel is free
  if (!ongoing_req) {
    // Set OCP command type
    if (!(cnt&0x7)){
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, 8*sizeof(Td));
      req->set_command((cnt&0x8)?tlm::TLM_READ_COMMAND:tlm::TLM_WRITE_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ipP.validate_extension<ocpip::burst_length>(*req);        
      ipP.validate_extension<ocpip::imprecise>(*req);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
      if (cnt&0x8) {
        req->set_address(addr & (~0x20)); // write and read same addresses
        //we add req info to read requests
        my_req_info* req_info;
        ipP.get_extension<my_req_info>(req_info, *req); 
        //the extensions are pooled with the transactions, so we might be reusing
        // an old extension. So we will only resize it if it is too small
        if (req_info->value.infos.size()<8) req_info->value.infos.resize(8);
        req_info->value.reset(); //we reset it, because it may be reused
        ipP.validate_extension<my_req_info>(*req); 
      }
      else
        req->set_address(addr);
    }
    ocpip::burst_length* b_len;
    ipP.get_extension<ocpip::burst_length>(b_len, *req);

    if (cnt&0x8) {
      if ((addr&0x1F)==0x1C)
        b_len->value=1;// End of burst
      else
        b_len->value=2; // imprecise burst continues
    } 
    else {
      if ((addr&0x1F)==0x1C)
        b_len->value=1; // End of burst
      else
        b_len->value=2; // imprecise burst continues
    }

    if (req->get_command() == tlm::TLM_WRITE_COMMAND){
      ipP.validate_extension<ocpip::posted>(*req);
      unsigned int burstcnt=cnt&0x7;
      *(((Td*)(req->get_data_ptr()))+burstcnt)=localData++;
    }
    else{ //read
      unsigned int burstcnt=cnt&0x7;
      my_req_info* req_info;
      ipP.get_extension<my_req_info>(req_info, *req);
      std::stringstream s;
      s<<"This is the req info for beat "<<burstcnt<<" of read transaction no."<<((cnt>>4)+1)<<" from "<<sc_module::name();
      req_info->value.infos[burstcnt]=s.str();
    }
    
    // Send request
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::BEGIN_REQ;
    tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
    switch(retVal){
      case tlm::TLM_ACCEPTED: ongoing_req=true; break;
      case tlm::TLM_UPDATED: 
        switch (phase){
          case tlm::END_REQ:
            break;
          default:
            std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_REQ."<<std::endl;
            exit(1);                
        }
        break;
      case tlm::TLM_COMPLETED:;
    }

      
#ifdef DEBUG_G1
    std::cout << "Master sent request " << req->get_command()
         << " time " << sc_core::sc_time_stamp().to_seconds();
    if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
      unsigned int burstcnt=cnt&0x7;
      std::cout << " data " << (*(((Td*)(req->get_data_ptr()))+burstcnt));
    }
    std::cout << std::endl;
#endif

    if (addr < 124)
      addr += 4;
    else
      addr = 0;
  
    cnt++;
  }

  if (resp) {
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::END_RESP;
    ipP->nb_transport_fw(*resp, phase, time);
    
    if (resp->get_response_status() == tlm::TLM_OK_RESPONSE) {
#ifdef DEBUG_G1
      std::cout << "Master got valid response "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  data  = " << (*(((Td*)(resp->get_data_ptr()))+rspcnt)) << std::endl;
#endif
    }
    if (rspcnt==7) { //end of burst
      ipP.release_transaction(resp); //we are done with this txn now
      rspcnt=0;
    }
    else
      rspcnt++;
    resp=NULL;
  }
    
} // end of method

tlm::tlm_sync_enum Master::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      break;
    case tlm::BEGIN_RESP: resp=&txn;
      break;
    default:
      std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
      exit(1);
  }
  return tlm::TLM_ACCEPTED;
}

