// 
//  (c) Copyright OCP-IP 2003, 2004, 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
// generic call operators and specialization for sc_port usage
#ifndef _OCP_FUNCTORS_H
#define _OCP_FUNCTORS_H

#ifndef SYSTEMC_H
#include <systemc.h>
#endif

// Would like to use boost/function for this stuff. Need to convince
// the committee that we can refer to boost in the distro 
namespace OcpIp {
template <typename ReturnT, typename ArgT=void>
struct Functor {
    virtual ReturnT operator() ( ArgT ) = 0;
};

template <typename ReturnT>
struct Functor<ReturnT, void> {
    virtual ReturnT operator() () = 0;
};

template <typename ArgT>
struct Functor<void, ArgT> {
    virtual void operator() ( ArgT ) = 0;
};

template <typename ObjT, typename ReturnT, typename ArgT, ReturnT (ObjT::*member) ( ArgT ) >
struct MemberFunctor : public Functor<ReturnT, ArgT> {
    MemberFunctor( ObjT& o ) : _o( o ) {}
    virtual ReturnT operator()( ArgT data ) {
        return ( _o.*member )( data );
    }
    ObjT& _o;
};

template <typename ObjT, typename ArgT, void (ObjT::*member) ( ArgT ) >
struct MemberFunctor<ObjT, void, ArgT, member> : public Functor<void, ArgT> {
    MemberFunctor( ObjT& o ) : _o( o ) {}
    virtual void operator()( ArgT data ) { 
	( _o.*member )( data );
    }
    ObjT& _o;
};

// This is hacked as a different template since gcc cannot understand
// specializing the function argument with ArgT=void
template <typename ObjT, typename ReturnT, ReturnT (ObjT::*member) ( void ) const >
struct MemberVoidFunctor : public Functor<ReturnT> {
    MemberVoidFunctor( ObjT& o ) : _o( o ) {}
    virtual ReturnT operator()( void ) {
        return ( _o.*member )();
    }
    ObjT& _o;
};

template <typename IF, typename ReturnT, typename ArgT, ReturnT (IF::*member) ( ArgT ) >
struct PortFunctor : public Functor<ReturnT, ArgT> {
    PortFunctor( sc_port<IF>& p ) : _p( p ) {}
    virtual ReturnT operator()( ArgT data ) {
	return ( _p[0]->*member )( data );
    }
    sc_port<IF>&  _p;
};

template <typename IF, typename ArgT, void (IF::*member) ( ArgT ) >
struct PortFunctor<IF, void, ArgT, member> : public Functor<void, ArgT> {
    PortFunctor( sc_port<IF>& p ) : _p( p ) {}
    virtual void operator()( ArgT data ) {
	( _p[0]->*member )( data );
    }
    sc_port<IF>&  _p;
};

// This is hacked as a different template since gcc cannot understand
// specializing the function argument with ArgT=void
template <typename IF, typename ReturnT, ReturnT (IF::*member) ( void ) const>
struct PortVoidFunctor : public Functor<ReturnT> {
    PortVoidFunctor( sc_port<IF>& p ) : _p( p ) {}
    virtual ReturnT operator()() {
	return ( _p[0]->*member )();
    }
    sc_port<IF>&  _p;
};
}

#endif /*  _OCP_FUNCTORS_H */
