// 
//  Copyright 2005 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//           $Id: master.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_module_name name_): 
  sc_module (name_), ipP("ipPort") {

  // initialize common members
  tmp = 0;
  cnt = 0;
  req.MData = 0;
  req.MAddr = 0;
  req.MByteEn = 0xF;
  wraplen = 0;
  addr = 0;
  read = false;
  protbits = 0;
  burstcnt = 0;
  SC_METHOD(proc);
  sensitive_pos(clk); 
  dont_initialize();
  
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if channel is free
  tmp = !ipP->getSBusy();
  if (tmp) {
    // Set OCP command type
    if (cnt < 16) { // Incrementing bursts
      if (read) {
	req.MCmd = OCP_MCMD_RD;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr & (~0x20); // write and read same addresses
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  req.MReqLast = 1; // End of burst
	  read = false;
	  burstcnt=0;
	}
	else {
	  req.MReqLast = 0;
	  burstcnt++;
	}
      } 
      else {
	req.MCmd = OCP_MCMD_WR;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  req.MReqLast = 1; // End of burst
	  read = true;
	  burstcnt=0;
	}
	else {
	  req.MReqLast = 0;
	  burstcnt++;
	}	
      }
    }
    // ReadEx - Write
    else if (cnt < 17) { 
	req.MCmd = OCP_MCMD_RDEX;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 1;
	req.MReqLast = 1;
    }
    else if (cnt < 18) {  // correct readex-write
	req.MCmd = OCP_MCMD_WR;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr-4;
	req.MBurstLength = 1;
	req.MReqLast = 1;
    }
    else if (cnt < 19) { 
	req.MCmd = OCP_MCMD_RDEX;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr;
	req.MBurstLength = 1;
	req.MReqLast = 1;
    }
    else if (cnt < 20) {  // incorrect after readex
	req.MCmd = OCP_MCMD_RD;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr; 
	req.MBurstLength = 1;
	req.MReqLast = 1;
    }
    else if (cnt < 21) {  // release last lock
	req.MCmd = OCP_MCMD_WR;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_INCR;
	req.MAddr = addr-8;
	req.MBurstLength = 1;
	req.MReqLast = 1;
    }
    else { // Wrapping bursts
      wraplen = 8;
      if (read) {
	req.MCmd = OCP_MCMD_RD;
	req.MReqInfo = protbits;
	req.MBurstSeq = OCP_MBURSTSEQ_WRAP;
	req.MAddr = addr;
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  req.MReqLast = 1; // End of burst
	  read = false;
	  burstcnt=0;
	}
	else {
	  req.MReqLast = 0;
	  burstcnt++;
	}
      } 
      else {
	req.MCmd = OCP_MCMD_WR;
	req.MBurstSeq = OCP_MBURSTSEQ_WRAP;
	req.MAddr = addr;
	req.MBurstLength = 8;
	if (burstcnt==7) {
	  req.MReqLast = 1; // End of burst
	  read = true;
	  burstcnt=0;
	}
	else {
	  req.MReqLast = 0;
	  burstcnt++;
	}
      }
    }
    // Send request
    tmp = ipP->startOCPRequest(req);
    if (tmp) {
      
#ifdef DEBUG_G1
      cout << "Master sent request " << req.MCmd
	   << " time " << sc_time_stamp().to_seconds();
      if (req.MCmd == OCP_MCMD_WR) {
	cout << " data " << req.MData;
      }
      cout << endl;
#endif
      if (req.MCmd == OCP_MCMD_WR) 
	req.MData++;

      // Address generator
      if (wraplen) {
	  if ((addr+4) < ((addr & (~(wraplen-1)*4))+ wraplen*4))
	    addr = addr+4; 
	  else
	    addr = addr & (~((wraplen-1)*4));
      }
      else
	if (addr < 124)
	  addr += 4;
	else
	  addr = 0;
    
      cnt++;
    }
  }
  
  // Check for response
  tmp = ipP->getOCPResponse(resp, true);
  if (tmp) {
    if (resp.SResp == OCP_SRESP_DVA) {
#ifdef DEBUG_G1
      cout << "Master got valid response "
	   << "  time  = " << sc_time_stamp().to_seconds()
	   << "  data  = " << resp.SData << endl;
#endif
    }
  }
  
} // end of method



