// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia, Inc.,
//		  Tim Kogel, CoWare, Inc
//           $Id: 
//
//  Description : OCP TL3 Slave port declaration.
//
// ============================================================================

#ifndef OCP_TL3_SLAVEPORT_H
#define OCP_TL3_SLAVEPORT_H

#include "ocp_tl3_slave_if.h"


template <typename REQ> 
class OCP_TL3_SlaveRequestPort
: public sc_port< OCP_TL3_SlaveRequestIF<REQ> >
{
    public:

        // Constructor
        OCP_TL3_SlaveRequestPort(const char* name)
            : sc_port< OCP_TL3_SlaveRequestIF<REQ> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the TLM TL3 Channel using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveRequestIF<REQ> >( *this, &OCP_TL3_SlaveRequestIF<REQ>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveRequestIF<REQ> >( *this, &OCP_TL3_SlaveRequestIF<REQ>::RequestEndEvent ); }
};


template <typename RESP> 
class OCP_TL3_SlaveResponsePort
: public sc_port< OCP_TL3_SlaveResponseIF<RESP> >
{
    public:

        // Constructor
        OCP_TL3_SlaveResponsePort(const char* name)
            : sc_port< OCP_TL3_SlaveResponseIF<RESP> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the TLM TL3 Channel using event finders
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveResponseIF<RESP> >( *this, &OCP_TL3_SlaveResponseIF<RESP>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveResponseIF<RESP> >( *this, &OCP_TL3_SlaveResponseIF<RESP>::ResponseEndEvent ); }
};

template <typename REQ,typename RESP> 
class OCP_TL3_SlavePort
: public sc_port< OCP_TL3_SlaveIF<REQ,RESP> >
{
    public:

        // Constructor
        OCP_TL3_SlavePort(const char* name)
            : sc_port< OCP_TL3_SlaveIF<REQ,RESP> >(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the TLM TL3 Channel using event finders
	sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveRequestIF<REQ> >( *this, &OCP_TL3_SlaveRequestIF<REQ>::RequestStartEvent ); }
	sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveRequestIF<REQ> >( *this, &OCP_TL3_SlaveRequestIF<REQ>::RequestEndEvent ); }
	sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveResponseIF<RESP> >( *this, &OCP_TL3_SlaveResponseIF<RESP>::ResponseStartEvent ); }
	sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL3_SlaveResponseIF<RESP> >( *this, &OCP_TL3_SlaveResponseIF<RESP>::ResponseEndEvent ); }
};

#endif   // OCP_TL3_SLAVEPORT_H

