// 
// Copyright 2005 OCP-IP
// OCP-IP Confidential & Proprietary
//
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia, Inc.,
//		  Tim Kogel, CoWare, Inc
//           $Id:
//
//  Description : OCP TL2 Master port definition.
//  
//	   Todo : delayed port classes with event finders
// ============================================================================

#ifndef TLM_TL3_MASTERPORT_H
#define TLM_TL3_MASTERPORT_H

#include "ocp_tl3_master_if.h"


template <class REQ> 
class OCP_TL3_MasterRequestPort
  : public sc_port< OCP_TL3_MasterRequestIF<REQ> >
{
public:

  // Constructor
  OCP_TL3_MasterRequestPort(const char* name)
    : sc_port< OCP_TL3_MasterRequestIF<REQ> >(name)
  {
    // do nothing
  }

  // Access to the "in-band" events of the TLM TL2 Channel using event finders
  sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterRequestIF<REQ> >( *this, &OCP_TL3_MasterRequestIF<REQ>::RequestStartEvent ); }
  sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterRequestIF<REQ> >( *this, &OCP_TL3_MasterRequestIF<REQ>::RequestEndEvent ); }
};

template <class RESP> 
class OCP_TL3_MasterResponsePort
  : public sc_port< OCP_TL3_MasterResponseIF<RESP> >
{
public:

  // Constructor
  OCP_TL3_MasterResponsePort(const char* name)
    : sc_port< OCP_TL3_MasterResponseIF<RESP> >(name)
  {
    // do nothing
  }

  // Access to the "in-band" events of the TLM TL2 Channel using event finders
  sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterResponseIF<RESP> >( *this, &OCP_TL3_MasterResponseIF<RESP>::ResponseStartEvent ); }
  sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterResponseIF<RESP> >( *this, &OCP_TL3_MasterResponseIF<RESP>::ResponseEndEvent ); }
};


template <typename REQ,typename RESP> 
class OCP_TL3_MasterPort
  : public sc_port< OCP_TL3_MasterIF<REQ,RESP> >
{
public:

  // Constructor
  OCP_TL3_MasterPort(const char* name)
    : sc_port< OCP_TL3_MasterIF<REQ,RESP> >(name)
  {
    // do nothing
  }
  
  sc_event_finder& RequestStartEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterRequestIF<REQ> >( *this, &OCP_TL3_MasterRequestIF<REQ>::RequestStartEvent ); }
  sc_event_finder& RequestEndEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterRequestIF<REQ> >( *this, &OCP_TL3_MasterRequestIF<REQ>::RequestEndEvent ); }
  sc_event_finder& ResponseStartEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterResponseIF<RESP> >( *this, &OCP_TL3_MasterResponseIF<RESP>::ResponseStartEvent ); }
  sc_event_finder& ResponseEndEvent() const { return *new sc_event_finder_t<OCP_TL3_MasterResponseIF<RESP> >( *this, &OCP_TL3_MasterResponseIF<RESP>::ResponseEndEvent ); }
};

#endif  // OCP_TL3_MASTERPORT_H

