// 
//  (c) Copyright OCP-IP 2003, 2004, 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
// utility classes for async value get/set
#ifndef _OCP_ASYNC_SIGNAL_RELAY_H
#define _OCP_ASYNC_SIGNAL_RELAY_H

#include "functors.h"
#ifndef SYSTEMC_H
#include <systemc.h>
#endif

namespace OcpIp {
template <typename dataT>
class AsyncSignalRelay : public sc_module {
  public:
    SC_HAS_PROCESS(AsyncSignalRelay);
    AsyncSignalRelay( sc_module_name name, sc_event_finder&    trigger,
                      Functor< dataT, void>& from,
                      Functor<void, dataT>&  to ) :
        sc_module( name ),
        m_from   ( from ),
        m_to     ( to )
        {
            SC_METHOD( forward );
            sensitive << trigger;
            dont_initialize();
        }
    AsyncSignalRelay( sc_module_name name,
                      sc_event_finder&    trigger1, sc_event_finder& trigger2,
                      Functor< dataT, void>& from,
                      Functor<void, dataT>&  to ) :
        sc_module( name ),
        m_from   ( from ),
        m_to     ( to )
        {
            SC_METHOD( forward );
            sensitive << trigger1 << trigger2;
            dont_initialize();
        }

    void forward() {
        m_to( m_from() );
    }
  private:
    Functor<dataT, void>& m_from;
    Functor<void, dataT>& m_to;
};

}
#endif /* _OCP_ASYNC_SIGNAL_RELAY_H */
