//
//  (c) Copyright OCP-IP 2003
//  OCP-IP Confidential and Proprietary
//  $Id:

#ifndef _ocp20SlaveSysC_h
#define _ocp20SlaveSysC_h

#include <iostream>
#include <map>
#include <deque>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"

#include "SlaveThreadedRespQ.h"

#include "MemoryCl.h"


// define the SlaveSysC class
template <typename TdataCl>
class SlaveSysC : public sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef typename TdataCl::DataType Td;
    typedef typename TdataCl::AddrType Ta;
    typedef map< Ta, Td > MemMapType;

    struct ReqQElement {
        OCPRequestGrp<Td,Ta> request;
        sc_time respSendTime;
    };

    // member definitions

    // channel port
    OCP_TL1_SlavePort<TdataCl> tpP;

    // NOTE: clock ports not used in this basic example
    // clock port
    // sc_in_clk ocpClkP;

    // NOTE: clock ports not used in this basic example
    // clock port
    // sc_in_clk clkP;

    // Systemc macros

    // has SystemC processes
    SC_HAS_PROCESS(SlaveSysC);

    // constructor and destructor
    SlaveSysC(sc_module_name, double, sc_time_unit, int, Ta, ostream* debug_os_ptr = NULL);
    ~SlaveSysC();

    // methods
    void resetState(void);
    void setConfiguration( MapStringType& passedMap );
    void processRequest( OCPRequestGrp<Td,Ta>& req, sc_time& send_time);
    void processReqQ(void);
    void freeSThreadBusy(void);

    void slaveResetMethod();
    void requestThreadProcess();
    void dataHSThreadProcess();
    void responseThreadProcess();
    void exerciseSidebandThreadProcess();
    void exerciseSResetProcess();

  private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // methods
    bool MputDirect(int, bool, Td*, Ta, int);

    // member definitions

    // slave identification
    int  m_ID;

    // ocp clock information
    double       m_ocpClkPeriod;
    sc_time_unit m_ocpClkTimeUnit;

    // number of memory bytes and the memory array
    Ta   m_MemoryByteSize;

    // model a queue of requests waiting for data
    deque<ReqQElement> *m_requestQ;

    // Temporary storage for concurrent data that arrives ahead
    // of the request:
    bool m_concurrentDataWaiting;
    OCPDataHSGrp<Td> m_dataHeld;

    // Tracking to make sure data is not accepted before the corresponding request
    int *m_writeReqAccepts;

    // model a per thread response queue
    // must be a pointer as is a function of number of threads
    ThreadedRespQ<TdataCl> *m_RespQueuePtr;

    MemoryCl<TdataCl> *m_Memory;

    ostream* m_debug_os_ptr;

    // current value of SThreadBusy as set by this Slave.
    unsigned int m_curSThreadBusy;

    // Is the Slave in Reset Mode?
    bool m_Reset;

    // ------------------------------------------------------------
    //  Parameters of the connected OCP channel
    // ------------------------------------------------------------
    // TODO: this is awkward. Better to use it at end-of-elaboration time to set member values.
    OCPParameters* m_OCPParamP;

    // Number of threads in the OCP channel
    int m_threads;

    // Does the channel use data handshaking?
    bool m_datahandshake;

    // Does the channel use data handshake accept?
    bool m_dataaccept;

    // Are writes with responses part of the OCP channel?
    bool m_writeresp_enable;

    // is SThreadBusy part of the OCP channel?
    bool m_sthreadbusy;

    // do we follow the rules of sthread_busy exact?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the OCP channel?
    bool m_mthreadbusy;

    // is SCmdAccept part of the OCP channel?
    bool m_cmdaccept;

    // is MByteEnable part of the OCP channel?
    bool m_byteen;

    // is MDataByteEnable part of the OCP channel?
    bool m_mdatabyteen;

    int m_addrIncr;

    // ------------------------------------------------------------
    //  Parameters of the Slave Model 
    // ------------------------------------------------------------

    // should there be a limit to the number of outstanding requests per thread?
    // default = false;
    bool m_limitreq_enable;

    // maximum number of outstanding requests per thread
    // default = 4;
    int m_limitreq_max;

    // Response Latency
    int *m_Latency;

    MapStringType m_ParamMap;

};

#endif // _ocp20SlaveSysC_h
