#ifndef _SIMPLE_MASTER_H
#define _SIMPLE_MASTER_H

// OCP-IP Channel header files
#include "globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

// define the Master transactor class
template <typename TdataCl>
class Master : public sc_module, public OCP_TL1_Slave_TimingIF
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef typename TdataCl::DataType Td;
    typedef typename TdataCl::AddrType Ta;

    // member definitions

    // channel port
    OCP_TL1_MasterPort<TdataCl> ipP;
    sc_in_clk clk;

    // SystemC macros
    // has SystemC processes
    SC_HAS_PROCESS(Master);

    // constructor and destructor
    Master(sc_module_name,
           int, ostream* debug_os_ptr = NULL);
    ~Master();

    // methods
    void provideChannelConfiguration( MapStringType&);
    void setOCPTL1SlaveTiming(OCP_TL1_Slave_TimingCl);
    void setModuleConfiguration(MapStringType&);

    // process methods
    void requestThreadProcess();
    void responseThreadProcess();
    void exerciseSidebandThreadProcess();
  
private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // member definitions

    // master identification
    int          m_ID;

    //
    ostream* m_debug_os_ptr;

    // Parameters from the OCP Channel:

    // The number of threads
    int m_threads;
    
    // is MAddrSpace part of the OCP channel?
    bool m_addrspace;

    // is SThreadBusy part of the channel?
    bool m_sthreadbusy;

    // Is SThreadBusy compliance required?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the channel?
    bool m_mthreadbusy;

    // Is MThreadBusy compliance required?
    bool m_mthreadbusy_exact;

    // is MRespAccept part of the channel?
    bool m_respaccept;

    // is Data Handshake part of the channel?
    bool m_datahandshake;

    // is write response part of the channel?
    bool m_writeresp_enable;

    // is the READ-EX command part of the channel
    bool m_readex_enable;

    // Are non-posted writes (write commands that receive responses) 
    // part of the channel?
    bool m_writenonpost_enable; 

    //-----------------------------------------
    //  Master Specific Parameters
    //-----------------------------------------

    // Response delay style - fixed or random
    bool m_respaccept_fixeddelay;

    // Delay in accepting responses (max delay for random)
    int m_respaccept_delay;
    
    // Map of string to string that holds the Master's paramter values
    OCPParameters m_parameters;
    
    sc_time m_sthreadbusy_sample_time;
};

#endif // _SIMPLE_MASTER_H
