// (c) Copyright OCP-IP 2004 - 2006
// OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Original Authors :
//                Anssi Haverinen, Nokia Inc.
//                Alan Kamas, for Sonics Inc.
//                Joe Chou, Sonics Inc.
//                James Aldis, Texas Instruments Inc.
//           $Id: ocp_tl1_trace_monitor.h,v 1.2 2006/03/11 21:35:52 Anssi Exp $
//
//  Description : Dummy trace monitor
//
// ============================================================================


#ifndef _OCP_TL1_TRACE_MONITOR_H
#define _OCP_TL1_TRACE_MONITOR_H
#include <iostream>
#include <iomanip>
#include <string>
#include <bitset>

#include "ocp_tl1_monitor_port.h"

// forward declaration needed for the class below:
template <class TdataCl> class OCP_TL1_Channel;

template<typename TdataCl>
class OCP_TL1_Trace_Monitor : public sc_module
{
 public:

  OCP_TL1_MonitorPort<TdataCl> p_mon;
  sc_in<bool> p_clk;

  OCP_TL1_Trace_Monitor(sc_module_name mn,
			std::string monFileName = "",
			bool print_params = true)
    : sc_module(mn), 
      p_mon("p_mon"),
      p_clk("p_clk"),
      monFile(monFileName.c_str())
  {
  }

  // Destructor
  ~OCP_TL1_Trace_Monitor()
  {
    monFile << "OCP Monitor package not installed. See www.ocpip.org." << endl;    
    monFile.close();
  }
  ofstream monFile;
};

#endif
