///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
ocpip_legacy::ParamCl<DATA_CL>& OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::get_params(){
  if (!m_ocp_params_valid){
    const typename OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types>::bind_base_type* init  =ocp_observer_base::get_connected_initiator();
    const typename OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types>::bind_base_type* target=ocp_observer_base::get_connected_target();
    //assert(init);
    //assert(target);
    const ocp_socket_base* tmp_i=dynamic_cast<const ocp_socket_base* >(init);
    const ocp_socket_base* tmp_t=dynamic_cast<const ocp_socket_base* >(target);
    if (!tmp_i && !tmp_t){
      std::cerr<<"Error: OCP Monitor "<<ocp_observer_base::get_name()<<" connected on a non-OCP connection."<<std::endl;
      abort();
    }
    ocp_parameters ocp_params_tmp_i, ocp_params_tmp_t;
    if (init){  //other is a ocp base socket
      if (tmp_i){ //it even is an ocp socket
        ocp_params_tmp_i=tmp_i->get_ocp_config();
      }
      else{ //is is a non-ocp ocp base socket
        assert(0 && "Not supported.");
        exit(666);
      }
    }
    else //it is not a ocp base socket, so we assume plain OSCI (compatibility on extension level is there, so we just set up an ocp conf for that)
      ocp_params_tmp_i.init_as_osci_config(BUSWIDTH);

    if (target){  //other is a ocp base socket
      if (tmp_t){ //it even is an ocp socket
        ocp_params_tmp_t=tmp_t->get_ocp_config();
      }
      else{ //is is a non-ocp ocp base socket
        assert(0 && "Not supported.");
        exit(666);
      }
    }
    else //it is not a ocp base socket, so we assume plain OSCI (compatibility on extension level is there, so we just set up an ocp conf for that)
      ocp_params_tmp_t.init_as_osci_config(BUSWIDTH);

    ocp_config_support<OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types> >::check_against_ocp_conf(
                             ocp_config_support<OCPIP_VERSION::infr::bind_checker<tlm::tlm_base_protocol_types> >::OCP_MST
                           , ocp_params_tmp_i
                           , ocp_params_tmp_t
                           , ocp_params_tmp_i);
    m_ocp_params=ocp_params_tmp_i.template legacy_conversion<DATA_CL>();
    m_ocp_params_valid=true;
  }
  return m_ocp_params;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::peq_cb(tlm::tlm_generic_payload& txn, const tlm::tlm_phase& ph){
  mon_delay_info* mon_info;
  m_converter.acc(txn).get_extension(mon_info);
  assert(mon_info);
  if (mon_info->callNreturn)
    nb_call_callback(mon_info->fwNbw, txn, ph, m_null_time);
  else
    nb_return_callback(mon_info->fwNbw, txn, ph, m_null_time, mon_info->retVal);
  m_monInfoPool.recycle(mon_info);
  m_converter.acc(txn).clear_extension(mon_delay_info::priv_id);
}


template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::nb_call_callback(
                        bool fwNbw
                       ,tlm::tlm_generic_payload& txn
                       ,const tlm::tlm_phase& phase
                       ,const sc_core::sc_time& time)
{
  if (time!=sc_core::SC_ZERO_TIME){
    mon_delay_info* mon_info=m_monInfoPool.create();
    mon_info->fwNbw=fwNbw;
    mon_info->callNreturn=true;
    m_converter.acc(txn).set_extension(mon_info);
    tlm::tlm_phase ph=phase;
    m_peq.notify(txn, ph, time);
    return;
  }
  if (fwNbw){ //forward call
    switch (phase){
      case tlm::BEGIN_REQ:
        m_req_grp_ack.setDelayed(false);
        //we gotta check if we have already seen that thing
        if (m_converter.acc(txn).get_extension(converter_type::have_seen_it::priv_id)) //if so, just update the things that have valid values
          m_req_grp.setDelayed(m_converter.update_req(txn));
        else {//otherwise take everything out of the txn because now it is stable
          m_req_grp.setDelayed(m_converter.fill_req(txn));
          m_running_txns.insert(&txn);
        }
        break;
      case tlm::END_RESP:
        m_response_grp_ack.setDelayed(true);
        if (m_converter.check_end_of_monitoring(txn, 2)) m_running_txns.erase(&txn);
        break;
      default:
        if (phase==BEGIN_DATA){
          m_datahs_grp_ack.setDelayed(false);
          m_datahs_grp.setDelayed(m_converter.update_dhs(txn));
        }
        else
        if (phase==RESP_THREAD_BUSY_CHANGE){
          m_mtb.setDelayed(m_converter.template get_extension<resp_thread_busy>(txn)->value);
        }
        else
        if (phase==BEGIN_RESET){
          m_mreset.setDelayed(false);
        }
        else
        if (phase==END_RESET){
          m_mreset.setDelayed(true);
          for (std::set<tlm::tlm_generic_payload*>::iterator i=m_running_txns.begin(); i!=m_running_txns.end(); i++)
            m_converter.check_end_of_monitoring(**i, 3);
          m_running_txns.clear();
        }
        else{
          std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on forward call of link "<<ocp_observer_base::get_name()<<std::endl;
        }
    }
  }
  else{ //backward call
    switch (phase){
      case tlm::END_REQ:
        m_req_grp_ack.setDelayed(true);
        //no dhs and write without response could mean the txn is over, so we check that
        if (!get_params().datahandshake && txn.is_write() && !get_params().writeresp_enable){
          if (m_converter.check_end_of_monitoring(txn, 0)) m_running_txns.erase(&txn);
        }
        break;
      case tlm::BEGIN_RESP:
        m_response_grp_ack.setDelayed(false);
        m_response_grp.setDelayed(m_converter.update_rsp(txn));
        break;
      default:
        if (phase==END_DATA) {
          m_datahs_grp_ack.setDelayed(true);
          if (!get_params().writeresp_enable && extension_api::get_extension<posted>(txn)) {
            // no write resp for posted write, so txn could be over
            if (m_converter.check_end_of_monitoring(txn, 1)) m_running_txns.erase(&txn);
          }
        }
        else
        if (phase==CMD_THREAD_BUSY_CHANGE){
          m_stb.setDelayed(m_converter.template get_extension<cmd_thread_busy>(txn)->value);
        }
        else
        if (phase==DATA_THREAD_BUSY_CHANGE){
          m_stb.setDelayed(m_converter.template get_extension<data_thread_busy>(txn)->value);
        }
        else
        if (phase==BEGIN_RESET){
          m_sreset.setDelayed(false);
        }
        else
        if (phase==END_RESET){
          m_sreset.setDelayed(true);
          for (std::set<tlm::tlm_generic_payload*>::iterator i=m_running_txns.begin(); i!=m_running_txns.end(); i++)
            m_converter.check_end_of_monitoring(**i, 3);
          m_running_txns.clear();
        }
        else{
          std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on backward call of link "<<ocp_observer_base::get_name()<<std::endl;
        }
    }
  }
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::nb_return_callback(
                          bool fwNbw
                         ,tlm::tlm_generic_payload& txn
                         ,const tlm::tlm_phase& phase
                         ,const sc_core::sc_time& time
                         ,tlm::tlm_sync_enum retVal)
{
  if (time!=sc_core::SC_ZERO_TIME){
    mon_delay_info* mon_info=m_monInfoPool.create();
    mon_info->fwNbw=fwNbw;
    mon_info->callNreturn=true;
    mon_info->retVal=retVal;
    m_converter.acc(txn).set_extension(mon_info);
    tlm::tlm_phase ph=phase;
    m_peq.notify(txn, ph, time);
    return;
  }

  if (fwNbw){ //return from fw call
    switch(retVal){
      case tlm::TLM_ACCEPTED: break;
      case tlm::TLM_UPDATED:
        switch (phase){
          case tlm::END_REQ:
            m_req_grp_ack.setDelayed(true);
            //no dhs and write without response could mean the txn is over, so we check that
            if (!get_params().datahandshake && txn.is_write() && !get_params().writeresp_enable){
              if (m_converter.check_end_of_monitoring(txn, 0)) m_running_txns.erase(&txn);
            }
            break;
          default:
            if (phase==END_DATA){ //only allowed to be piggy bagged on BEGIN_DATA
              m_datahs_grp_ack.setDelayed(true);
              if (!get_params().writeresp_enable && extension_api::get_extension<posted>(txn)) {
                //no write resp for posted write, so txn could be over
                if(m_converter.check_end_of_monitoring(txn, 1)) m_running_txns.erase(&txn);
              }
            }
            else{
              std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on updated return from forward call of link "
                       <<ocp_observer_base::get_name()<<std::endl;
            }
        }
        break;
      case tlm::TLM_COMPLETED:
        std::cerr<<"Monitor warning: Unexpected TLM_COMPLETED on updated return from forward call of link "
                 <<ocp_observer_base::get_name()<<std::endl;
    }
  }
  else { //return from bw call
    switch(retVal){
      case tlm::TLM_ACCEPTED: break;
      case tlm::TLM_UPDATED:
        switch (phase){
          case tlm::END_RESP:
            m_response_grp_ack.setDelayed(true);
            if (m_converter.check_end_of_monitoring(txn, 2)) m_running_txns.erase(&txn);
            break;
          default:
            std::cerr<<"Monitor warning: Unexpected phase "<<phase<<" on updated return from backward call of link "
                     <<ocp_observer_base::get_name()<<std::endl;
        }
        break;
      case tlm::TLM_COMPLETED:
          std::cerr<<"Monitor warning: Unexpected TLM_COMPLETED on updated return from backward call of link "
                   <<ocp_observer_base::get_name()<<std::endl;
    }
  }
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::b_call_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time){
  std::cerr<<"Monitor warning: B_transport monitoring not supported yet on link "<<ocp_observer_base::get_name()<<std::endl;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::b_return_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time){
  std::cerr<<"Monitor warning: B_transport monitoring not supported yet on link "<<ocp_observer_base::get_name()<<std::endl;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
template <unsigned int BUSWIDTH_>
OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::ocp_tl1_monitor_adapter(OCPIP_VERSION::infr::monitor<BUSWIDTH_, tlm::tlm_base_protocol_types>& mon)
  : ocp_observer_base(&mon)
  , m_converter(ocp_observer_base::get_name(), this, &ocp_tl1_monitor_adapter::get_params)
  , m_peq(this, &ocp_tl1_monitor_adapter::peq_cb, &m_converter)
  , m_null_time(sc_core::SC_ZERO_TIME)
  , m_ocp_params_valid(false)
  , m_req_grp(m_null_req)
  , m_response_grp(m_null_rsp)
  , m_datahs_grp(m_null_dhs)
  , m_req_grp_ack(false)
  , m_response_grp_ack(false)
  , m_datahs_grp_ack(false)
  , m_mtb(0)
  , m_stb(0)
  , m_sdtb(0)
  , m_mreset(true)
  , m_sreset(true)
  , m_cmd_trace_time(sc_core::SC_ZERO_TIME)
  , m_data_valid_trace_time(sc_core::SC_ZERO_TIME)
  , m_resp_trace_time(sc_core::SC_ZERO_TIME)
  , m_cmd_trace(ocpip_legacy::OCP_MCMD_IDLE)
  , m_data_valid_trace(false)
  , m_resp_trace(ocpip_legacy::OCP_SRESP_NULL)
  , m_monInfoPool(5)
{
}

  // Monitor access
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const ocpip_legacy::OCPMCmdType OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH, DATA_CL>::getMCmdTrace () const {
  if (sc_core::sc_time_stamp()!=m_cmd_trace_time){ //first test in cycle, see what we have
    m_cmd_trace=m_req_grp.get().MCmd;
    m_req_grp.get().MCmd=ocpip_legacy::OCP_MCMD_IDLE;
    m_cmd_trace_time=sc_core::sc_time_stamp();
  }
  return m_cmd_trace;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::getMDataValidTrace ()  const {
  if (sc_core::sc_time_stamp()!=m_data_valid_trace_time){ //first test in cycle, see what we have
    m_data_valid_trace=m_datahs_grp.get().MDataValid;
    m_datahs_grp.get().MDataValid=false;
    m_data_valid_trace_time=sc_core::sc_time_stamp();
  }
  return m_data_valid_trace;

}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const ocpip_legacy::OCPSRespType OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::getSRespTrace () const {
  if (sc_core::sc_time_stamp()!=m_resp_trace_time){ //first test in cycle, see what we have
    m_resp_trace=m_response_grp.get().SResp;
    m_response_grp.get().SResp=ocpip_legacy::OCP_SRESP_NULL;
    m_resp_trace_time=sc_core::sc_time_stamp();
  }
  return m_resp_trace;
}


template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const std::string OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekChannelName()const{return ocp_observer_base::get_name();}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const std::string OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekMasterPortName()const {return ocp_observer_base::get_connected_initiator()->get_name();}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const std::string OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSlavePortName()const {return ocp_observer_base::get_connected_target()->get_name();}

// transactions
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const typename OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::request_type& OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekOCPRequest()const {
  static request_type tmp;
  tmp=m_req_grp.get();
  tmp.MCmd=getMCmdTrace();
  return tmp;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const typename OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::datahs_type& OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekDataHS() const {
  static datahs_type tmp;
  tmp=m_datahs_grp.get();
  tmp.MDataValid=getMDataValidTrace();
  return tmp;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const typename OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::response_type& OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekOCPResponse() const {
  static response_type tmp;
  tmp=m_response_grp.get();
  tmp.SResp=getSRespTrace();
  return tmp;
}


template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekRequestEnd() const {
  bool retVal=m_req_grp.get().MCmdSaved!=ocpip_legacy::OCP_MCMD_IDLE && m_req_grp_ack.get();
  if (retVal && !m_req_grp.alreadySetDelayed()) m_req_grp.setDelayed(m_null_req);
  //DUMP("ENDREQ "<<retVal);
  return retVal;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekRequestStart() const {
  //DUMP("STARTREQ "<<(m_req_grp.get().MCmdSaved!=OCP_MCMD_IDLE && !peekRequestEnd()));
  return m_req_grp.get().MCmdSaved!=ocpip_legacy::OCP_MCMD_IDLE && !peekRequestEnd();
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekRequestEarlyEnd() const {
  //DUMP("ERLYENDREQ "<<(m_req_grp.get().MCmdSaved!=OCP_MCMD_IDLE && peekRequestEnd()));
  return m_req_grp.get().MCmdSaved!=ocpip_legacy::OCP_MCMD_IDLE && peekRequestEnd();
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekResponseEnd() const {
  bool retVal=m_response_grp.get().SRespSaved!=ocpip_legacy::OCP_SRESP_NULL && m_response_grp_ack.get();
  if (retVal && !m_response_grp.alreadySetDelayed()) m_response_grp.setDelayed(m_null_rsp);
  return retVal;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekResponseStart() const {
  return m_response_grp.get().SRespSaved!=ocpip_legacy::OCP_SRESP_NULL && !peekResponseEnd();
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekResponseEarlyEnd() const {
  return m_response_grp.get().SRespSaved!=ocpip_legacy::OCP_SRESP_NULL && peekResponseEnd();
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekDataRequestEnd() const {
  bool retVal=m_datahs_grp.get().MDataValidSaved && m_datahs_grp_ack.get();
  if (retVal && !m_datahs_grp.alreadySetDelayed()) m_datahs_grp.setDelayed(m_null_dhs);
  return retVal;
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekDataRequestStart() const {
  return m_datahs_grp.get().MDataValidSaved && !peekDataRequestEnd();
}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekDataRequestEarlyEnd() const {
  return m_datahs_grp.get().MDataValidSaved && peekDataRequestEnd();
}

// thread busy
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSThreadBusy() const {return m_stb.get();}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSDataThreadBusy() const {return m_sdtb.get();}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekMThreadBusy() const {return m_mtb.get();}

// reset
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekMReset_n()  const {return m_mreset.get();}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSReset_n()  const {return m_sreset.get();}

// sideband signals
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekMError()  const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekMFlag()  const {error(__func__); return 0;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSError()  const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSFlag()  const {error(__func__);return 0;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekSInterrupt() const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekControl()  const {error(__func__);return 0;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekControlWr()  const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekControlBusy() const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const unsigned int OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekStatus()  const {error(__func__);  return 0;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekStatusRd()  const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekStatusBusy() const {error(__func__); return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
const bool OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::peekExitAfterOCPMon() const {return false;}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
void OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::error(const char* func) const {//std::cout<<"Error "<<func<<" not implemented."<<std::endl; exit(1);
}

// OCP parameters
template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
typename OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::paramcl_type* OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::GetParamCl(){return &(get_params());}

template <unsigned int BUSWIDTH, unsigned int ADDRWIDTH, typename DATA_CL>
typename ocpip_legacy::OCPParameters* OCPIP_VERSION::ocp_tl1_monitor_adapter<BUSWIDTH,ADDRWIDTH,DATA_CL>::GetParameters(){return &(get_params());}

