// 
//  (c) Copyright OCP-IP 2003 - 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc.
//           $Id:
//
//  Description : OCP TL3 Master multiport
//
// ============================================================================

#ifndef OCP_TL3_MASTERMULTIPORT_H
#define OCP_TL3_MASTERMULTIPORT_H

#include "multiport_event_finder.h"
#include "ocp_tl3_master_if.h"


template<typename REQ, typename RESP>
class OCP_TL3_MasterMultiPort
  : public sc_port<OCP_TL3_MasterIF<REQ, RESP>, 0> {
 public:
  OCP_TL3_MasterMultiPort(const char* name )
    : sc_port<OCP_TL3_MasterIF<REQ, RESP>, 0>(name)
  {}

  // Access to the "in-band" events of the OCP TL3 Channel using event finders
  sc_event_finder& RequestStartEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_MasterIF<REQ, RESP> >( *this, &OCP_TL3_MasterIF<REQ, RESP>::RequestStartEvent, myPort ); 
  }
  sc_event_finder& RequestEndEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_MasterIF<REQ, RESP> >( *this, &OCP_TL3_MasterIF<REQ, RESP>::RequestEndEvent, myPort ); 
  }
  sc_event_finder& ResponseStartEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_MasterIF<REQ, RESP> >( *this, &OCP_TL3_MasterIF<REQ, RESP>::ResponseStartEvent, myPort ); 
  }
  sc_event_finder& ResponseEndEvent(int myPort = 0) const 
  { 
    return *new multiport_event_finder_t<OCP_TL3_MasterIF<REQ, RESP> >( *this, &OCP_TL3_MasterIF<REQ, RESP>::ResponseEndEvent, myPort ); 
  } 
};


#endif
