<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
 Description: XSL checking the configuration of the OCP-IP bus interface.
              Generated with generateOCPChecker.xsl
 Author: Christophe Amerijckx - STMicroelectronics
 Date: 2012-10-10T17:37:47.885+05:30
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:spirit="http://www.spiritconsortium.org/XMLSchema/SPIRIT/1685-2009" xmlns:spirit14="http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.4" xmlns:ocp="http://www.ocpip.org">
  <xsl:output  method="text" indent="yes"/>
  <!-- XSL template containing the computation of a log2 function -->
  <xsl:template name="log2"><xsl:param name="number"/><xsl:param name="result"/>
    <xsl:choose>
      <xsl:when test="ceiling($number) = 1">
        <xsl:value-of select="$result"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="log2">
          <xsl:with-param name="number" select="$number div 2"/>
          <xsl:with-param name="result" select="$result + 1"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- XSL template containing the computation of a pow function -->
  <xsl:template name="pow"><xsl:param name="number"/><xsl:param name="power"/><xsl:param name="result"/>
    <xsl:choose>
      <xsl:when test="$power = 0">
        <xsl:value-of select="1"/>
      </xsl:when>
      <xsl:when test="$power = 1">
        <xsl:value-of select="$result"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="pow">
          <xsl:with-param name="number" select="$number"/>
          <xsl:with-param name="power" select="$power - 1"/>
          <xsl:with-param name="result" select="$result * $number"/>
        </xsl:call-template>
      </xsl:otherwise>
   </xsl:choose>
  </xsl:template>
 <xsl:template name="max"><xsl:param name="number1"/><xsl:param name="number2"/>
    <xsl:choose>
      <xsl:when test="$number1 > $number2">
        <xsl:value-of select="$number1"/>
      </xsl:when>
      <xsl:otherwise>
		  <xsl:value-of select="$number2"/>
      </xsl:otherwise>
   </xsl:choose>
  </xsl:template>
  <!-- XSL template inserting a carriage return -->
  <xsl:template name="insertCR">
    <xsl:text>
</xsl:text>
  </xsl:template>
  <!-- Main template matching all the OCP interfaces of a component -->
  <xsl:template match="spirit:component">
    <xsl:for-each select="spirit:busInterfaces/spirit:busInterface[(spirit:busType/@spirit:vendor='ocpip.org') and (spirit:busType/@spirit:library='OCP') and (spirit:busType/@spirit:name='OCP2_2') and (spirit:busType/@spirit:version='1.0') and (spirit:abstractionType/@spirit:vendor='ocpip.org') and (spirit:abstractionType/@spirit:library='OCP') and (spirit:abstractionType/@spirit:name='OCP2_2_RTL') and (spirit:abstractionType/@spirit:version='1.0')]">
      <xsl:text>Interface </xsl:text><xsl:value-of select="spirit:name"/><xsl:call-template name="insertCR"/>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='broadcast_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='broadcast_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for broadcast_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burst_aligned']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burst_aligned']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burst_aligned , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_blck_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_blck_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_blck_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt1_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt1_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_dflt1_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt2_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt2_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_dflt2_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_incr_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_incr_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_incr_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_strm_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_strm_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_strm_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_unkn_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_unkn_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_unkn_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_wrap_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_wrap_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_wrap_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_xor_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq_xor_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq_xor_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='endian']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='endian']/spirit:value/@spirit:format!='string'">
		<xsl:text> Incorrect format for endian , format needs to be  string</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='force_aligned']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='force_aligned']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for force_aligned , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_exact']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_exact']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mthreadbusy_exact , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='rdlwrc_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='rdlwrc_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for rdlwrc_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='read_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='read_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for read_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='readex_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='readex_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for readex_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_exact']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_exact']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sdatathreadbusy_exact , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_exact']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_exact']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sthreadbusy_exact , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='tag_interleave_size']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='tag_interleave_size']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for tag_interleave_size , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='write_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='write_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for write_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='writenonpost_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='writenonpost_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for writenonpost_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datahandshake']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datahandshake']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for datahandshake , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqdata_together']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqdata_together']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for reqdata_together , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='writeresp_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='writeresp_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for writeresp_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addr']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addr']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for addr , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addr_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addr_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for addr_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addrspace']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addrspace']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for addrspace , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addrspace_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='addrspace_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for addrspace_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='atomiclength']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='atomiclength']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for atomiclength , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='atomiclength_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='atomiclength_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for atomiclength_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockheight']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockheight']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for blockheight , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockheight_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockheight_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for blockheight_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockstride']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockstride']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for blockstride , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockstride_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='blockstride_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for blockstride_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstlength']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstlength']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstlength , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstlength_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstlength_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for burstlength_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstprecise']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstprecise']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstprecise , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstseq']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstseq , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstsinglereq']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='burstsinglereq']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for burstsinglereq , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='byteen']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='byteen']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for byteen , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='cmdaccept']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='cmdaccept']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for cmdaccept , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='connid']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='connid']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for connid , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='connid_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='connid_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for connid_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='dataaccept']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='dataaccept']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for dataaccept , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datalast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datalast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for datalast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datarowlast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='datarowlast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for datarowlast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='data_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='data_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for data_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='enableclk']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='enableclk']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for enableclk , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdata']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdata']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mdata , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatabyteen']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatabyteen']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mdatabyteen , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mdatainfo , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for mdatainfo_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfobyte_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mdatainfobyte_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for mdatainfobyte_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mthreadbusy , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_pipelined']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_pipelined']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mthreadbusy_pipelined , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqinfo']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqinfo']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for reqinfo , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqinfo_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqinfo_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for reqinfo_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqlast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqlast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for reqlast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqrowlast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='reqrowlast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for reqrowlast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resp']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resp']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for resp , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respaccept']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respaccept']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for respaccept , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respinfo']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respinfo']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for respinfo , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respinfo_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='respinfo_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for respinfo_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resplast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resplast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for resplast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resprowlast']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='resprowlast']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for resprowlast , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdata']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdata']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sdata , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sdatainfo , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for sdatainfo_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfobyte_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatainfobyte_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for sdatainfobyte_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sdatathreadbusy , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_pipelined']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_pipelined']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sdatathreadbusy_pipelined , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sthreadbusy , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_pipelined']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_pipelined']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sthreadbusy_pipelined , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='tags']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='tags']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for tags , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='taginorder']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='taginorder']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for taginorder , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='threads']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='threads']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for threads , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='control']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='control']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for control , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='controlbusy']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='controlbusy']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for controlbusy , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='control_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='control_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for control_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='controlwr']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='controlwr']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for controlwr , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='interrupt']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='interrupt']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for interrupt , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='merror']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='merror']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for merror , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mflag']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mflag']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mflag , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mflag_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mflag_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for mflag_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mreset']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='mreset']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for mreset , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='serror']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='serror']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for serror , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sflag']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sflag']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sflag , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sflag_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sflag_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for sflag_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sreset']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='sreset']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for sreset , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='status']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='status']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for status , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='statusbusy']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='statusbusy']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for statusbusy , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='statusrd']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='statusrd']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for statusrd , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='status_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='status_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for status_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='clkctrl_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='clkctrl_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for clkctrl_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='jtag_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='jtag_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for jtag_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='jtagtrst_enable']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='jtagtrst_enable']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for jtagtrst_enable , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanctrl_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanctrl_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for scanctrl_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanport']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanport']/spirit:value/@spirit:format!='bool'">
		<xsl:text> Incorrect format for scanport , format needs to be  bool</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanport_wdth']">
		<xsl:if test="spirit:parameters/spirit:parameter[spirit:name='scanport_wdth']/spirit:value/@spirit:format!='long'">
		<xsl:text> Incorrect format for scanport_wdth , format needs to be  long</xsl:text> 
		<xsl:call-template name="insertCR"/>		</xsl:if>
	</xsl:if>
      <!-- Defining all the parameters values in a variable -->
      <xsl:variable name="broadcast_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='broadcast_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='broadcast_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burst_aligned">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burst_aligned']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burst_aligned']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_blck_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_blck_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_blck_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_dflt1_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt1_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt1_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_dflt2_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt2_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_dflt2_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_incr_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_incr_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_incr_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_strm_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_strm_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_strm_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_unkn_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_unkn_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_unkn_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_wrap_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_wrap_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_wrap_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq_xor_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq_xor_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq_xor_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="endian">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='endian']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='endian']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>little</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="force_aligned">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='force_aligned']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='force_aligned']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mthreadbusy_exact">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_exact']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_exact']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="rdlwrc_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='rdlwrc_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='rdlwrc_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="read_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='read_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='read_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="readex_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='readex_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='readex_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatathreadbusy_exact">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_exact']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_exact']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sthreadbusy_exact">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_exact']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_exact']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="tag_interleave_size">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='tag_interleave_size']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='tag_interleave_size']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="write_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='write_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='write_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="writenonpost_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='writenonpost_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='writenonpost_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="datahandshake">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='datahandshake']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='datahandshake']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="reqdata_together">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='reqdata_together']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='reqdata_together']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="writeresp_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='writeresp_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='writeresp_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="addr">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='addr']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='addr']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="addr_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='addr_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='addr_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="addrspace">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='addrspace']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='addrspace']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="addrspace_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='addrspace_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='addrspace_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="atomiclength">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='atomiclength']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='atomiclength']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="atomiclength_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='atomiclength_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='atomiclength_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="blockheight">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='blockheight']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='blockheight']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="blockheight_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='blockheight_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='blockheight_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>0</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="blockstride">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='blockstride']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='blockstride']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="blockstride_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='blockstride_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='blockstride_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstlength">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstlength']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstlength']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstlength_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstlength_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstlength_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>0</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstprecise">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstprecise']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstprecise']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstseq">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstseq']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstseq']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="burstsinglereq">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='burstsinglereq']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='burstsinglereq']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="byteen">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='byteen']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='byteen']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="cmdaccept">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='cmdaccept']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='cmdaccept']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="connid">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='connid']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='connid']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="connid_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='connid_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='connid_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="dataaccept">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='dataaccept']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='dataaccept']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="datalast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='datalast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='datalast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="datarowlast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='datarowlast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='datarowlast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="data_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='data_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='data_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="enableclk">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='enableclk']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='enableclk']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mdata">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mdata']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mdata']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mdatabyteen">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mdatabyteen']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mdatabyteen']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mdatainfo">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mdatainfo']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mdatainfo_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mdatainfo_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mdatainfo_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mdatainfobyte_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mdatainfobyte_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mdatainfobyte_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mthreadbusy">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mthreadbusy_pipelined">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_pipelined']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mthreadbusy_pipelined']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="reqinfo">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='reqinfo']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='reqinfo']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="reqinfo_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='reqinfo_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='reqinfo_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="reqlast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='reqlast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='reqlast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="reqrowlast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='reqrowlast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='reqrowlast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="resp">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='resp']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='resp']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="respaccept">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='respaccept']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='respaccept']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="respinfo">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='respinfo']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='respinfo']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="respinfo_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='respinfo_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='respinfo_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="resplast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='resplast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='resplast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="resprowlast">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='resprowlast']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='resprowlast']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdata">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdata']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdata']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>true</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatainfo">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatainfo']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatainfo_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatainfo_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatainfo_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatainfobyte_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatainfobyte_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatainfobyte_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatathreadbusy">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sdatathreadbusy_pipelined">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_pipelined']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sdatathreadbusy_pipelined']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sthreadbusy">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sthreadbusy_pipelined">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_pipelined']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sthreadbusy_pipelined']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="tags">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='tags']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='tags']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="taginorder">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='taginorder']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='taginorder']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="threads">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='threads']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='threads']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="control">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='control']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='control']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="controlbusy">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='controlbusy']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='controlbusy']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="control_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='control_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='control_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="controlwr">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='controlwr']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='controlwr']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="interrupt">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='interrupt']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='interrupt']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="merror">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='merror']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='merror']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mflag">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mflag']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mflag']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mflag_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mflag_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mflag_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="mreset">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='mreset']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='mreset']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="serror">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='serror']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='serror']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sflag">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sflag']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sflag']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sflag_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sflag_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sflag_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="sreset">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='sreset']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='sreset']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="status">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='status']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='status']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="statusbusy">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='statusbusy']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='statusbusy']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="statusrd">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='statusrd']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='statusrd']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="status_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='status_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='status_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="clkctrl_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='clkctrl_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='clkctrl_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="jtag_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='jtag_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='jtag_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="jtagtrst_enable">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='jtagtrst_enable']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='jtagtrst_enable']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="scanctrl_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='scanctrl_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='scanctrl_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="scanport">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='scanport']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='scanport']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>false</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="scanport_wdth">
        <xsl:choose>
          <xsl:when test="spirit:parameters/spirit:parameter[spirit:name='scanport_wdth']">
            <xsl:value-of select="spirit:parameters/spirit:parameter[spirit:name='scanport_wdth']/spirit:value"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <!-- Tests for logical port Clk -->
      <!-- Tests for logical port EnableClk -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='EnableClk']) and not($enableclk='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='EnableClk']) and ($enableclk='true'))">
        <xsl:text>  Port presence constraint is not verified for port EnableClk</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MAddr -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddr']) and not($addr='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddr']) and ($addr='true'))">
        <xsl:text>  Port presence constraint is not verified for port MAddr</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddr']) and $addr_wdth=''">
        <xsl:text>  Parameter addr_wdth should be present to check port width constraint on port MAddr.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddr']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MAddr']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($addr_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MAddr</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MCmd -->
      <!-- Tests for logical port MData -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MData']) and not($mdata='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MData']) and ($mdata='true'))">
        <xsl:text>  Port presence constraint is not verified for port MData</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MData']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check port width constraint on port MData.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MData']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MData']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($data_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MData</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MDataValid -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataValid']) and not($datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataValid']) and ($datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port MDataValid</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MRespAccept -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MRespAccept']) and not($respaccept='true' and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MRespAccept']) and ($respaccept='true' and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port MRespAccept</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SCmdAccept -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SCmdAccept']) and not($cmdaccept='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SCmdAccept']) and ($cmdaccept='true'))">
        <xsl:text>  Port presence constraint is not verified for port SCmdAccept</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SData -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SData']) and not($sdata='true' and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SData']) and ($sdata='true' and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port SData</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SData']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check port width constraint on port SData.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SData']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SData']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($data_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SData</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SDataAccept -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataAccept']) and not($dataaccept='true' and $datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataAccept']) and ($dataaccept='true' and $datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port SDataAccept</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SResp -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SResp']) and not($resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SResp']) and ($resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port SResp</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MAddrSpace -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddrSpace']) and not($addrspace='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddrSpace']) and ($addrspace='true'))">
        <xsl:text>  Port presence constraint is not verified for port MAddrSpace</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddrSpace']) and $addrspace_wdth=''">
        <xsl:text>  Parameter addrspace_wdth should be present to check port width constraint on port MAddrSpace.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAddrSpace']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MAddrSpace']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($addrspace_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MAddrSpace</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MByteEn -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MByteEn']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port MByteEn.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MByteEn']) and not($byteen='true' and ($mdata='true' or $sdata='true') and ($data_wdth mod 8 = 0))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MByteEn']) and ($byteen='true' and ($mdata='true' or $sdata='true') and ($data_wdth mod 8 = 0)))">
        <xsl:text>  Port presence constraint is not verified for port MByteEn</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MByteEn']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check port width constraint on port MByteEn.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MByteEn']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MByteEn']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($data_wdth div 8 = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MByteEn</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MDataByteEn -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataByteEn']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port MDataByteEn.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataByteEn']) and not($mdatabyteen='true' and $mdata='true' and $datahandshake='true' and ($data_wdth mod 8 = 0))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataByteEn']) and ($mdatabyteen='true' and $mdata='true' and $datahandshake='true' and ($data_wdth mod 8 = 0)))">
        <xsl:text>  Port presence constraint is not verified for port MDataByteEn</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataByteEn']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check port width constraint on port MDataByteEn.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataByteEn']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MDataByteEn']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($data_wdth div 8 = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MDataByteEn</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MDataInfo -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and $mdatainfo_wdth=''">
        <xsl:text>  Parameter mdatainfo_wdth should be present to check presence constraint on port MDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and $mdatainfobyte_wdth=''">
        <xsl:text>  Parameter mdatainfobyte_wdth should be present to check presence constraint on port MDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port MDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port MDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and not($mdatainfo='true' and ($mdatainfo_wdth >= ($mdatainfobyte_wdth * $data_wdth div 8)) and ($data_wdth mod 8 = 0))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and ($mdatainfo='true' and ($mdatainfo_wdth >= ($mdatainfobyte_wdth * $data_wdth div 8)) and ($data_wdth mod 8 = 0)))">
        <xsl:text>  Port presence constraint is not verified for port MDataInfo</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']) and $mdatainfo_wdth=''">
        <xsl:text>  Parameter mdatainfo_wdth should be present to check port width constraint on port MDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataInfo']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MDataInfo']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($mdatainfo_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MDataInfo</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MReqInfo -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqInfo']) and not($reqinfo='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqInfo']) and ($reqinfo='true'))">
        <xsl:text>  Port presence constraint is not verified for port MReqInfo</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqInfo']) and $reqinfo_wdth=''">
        <xsl:text>  Parameter reqinfo_wdth should be present to check port width constraint on port MReqInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqInfo']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MReqInfo']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($reqinfo_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MReqInfo</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SDataInfo -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and $sdatainfo_wdth=''">
        <xsl:text>  Parameter sdatainfo_wdth should be present to check presence constraint on port SDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and $sdatainfobyte_wdth=''">
        <xsl:text>  Parameter sdatainfobyte_wdth should be present to check presence constraint on port SDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port SDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and $data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present to check presence constraint on port SDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and not($sdatainfo='true' and $resp='true' and ($sdatainfo_wdth >= ($sdatainfobyte_wdth * $data_wdth div 8)) and ($data_wdth mod 8 = 0))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and ($sdatainfo='true' and $resp='true' and ($sdatainfo_wdth >= ($sdatainfobyte_wdth * $data_wdth div 8)) and ($data_wdth mod 8 = 0)))">
        <xsl:text>  Port presence constraint is not verified for port SDataInfo</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']) and $sdatainfo_wdth=''">
        <xsl:text>  Parameter sdatainfo_wdth should be present to check port width constraint on port SDataInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataInfo']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SDataInfo']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($sdatainfo_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SDataInfo</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SRespInfo -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespInfo']) and not($respinfo='true' and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespInfo']) and ($respinfo='true' and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port SRespInfo</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespInfo']) and $respinfo_wdth=''">
        <xsl:text>  Parameter respinfo_wdth should be present to check port width constraint on port SRespInfo.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespInfo']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SRespInfo']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($respinfo_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SRespInfo</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MAtomicLength -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAtomicLength']) and not($atomiclength='true' and $burstlength='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAtomicLength']) and ($atomiclength='true' and $burstlength='true'))">
        <xsl:text>  Port presence constraint is not verified for port MAtomicLength</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAtomicLength']) and $atomiclength_wdth=''">
        <xsl:text>  Parameter atomiclength_wdth should be present to check port width constraint on port MAtomicLength.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MAtomicLength']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MAtomicLength']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($atomiclength_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MAtomicLength</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MBlockHeight -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockHeight']) and not($blockheight='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true' and ($blockheight_wdth!=1))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockHeight']) and ($blockheight='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true' and ($blockheight_wdth!=1)))">
        <xsl:text>  Port presence constraint is not verified for port MBlockHeight</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockHeight']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MBlockHeight']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($blockheight_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MBlockHeight</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MBlockStride -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockStride']) and not($blockheight='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockStride']) and ($blockheight='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true'))">
        <xsl:text>  Port presence constraint is not verified for port MBlockStride</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockStride']) and $blockstride_wdth=''">
        <xsl:text>  Parameter blockstride_wdth should be present to check port width constraint on port MBlockStride.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBlockStride']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MBlockStride']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($blockstride_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MBlockStride</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MBurstLength -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstLength']) and not($burstlength='true' and ($burstlength_wdth!=1))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstLength']) and ($burstlength='true' and ($burstlength_wdth!=1)))">
        <xsl:text>  Port presence constraint is not verified for port MBurstLength</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstLength']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MBurstLength']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($burstlength_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MBurstLength</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MBurstPrecise -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstPrecise']) and not($burstprecise='true' and $burstlength='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstPrecise']) and ($burstprecise='true' and $burstlength='true'))">
        <xsl:text>  Port presence constraint is not verified for port MBurstPrecise</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MBurstSeq -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstSeq']) and not($burstseq='true' and $burstlength='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstSeq']) and ($burstseq='true' and $burstlength='true'))">
        <xsl:text>  Port presence constraint is not verified for port MBurstSeq</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MBurstSingleReq -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstSingleReq']) and not($burstsinglereq='true' and $burstlength='true' and ($datahandshake='true' or not($write_enable='true' or $writenonpost_enable='true' or $rdlwrc_enable='true')) and not($burstseq_unkn_enable='true' and not($burstseq_blck_enable='true' or $burstseq_dflt1_enable='true' or $burstseq_dflt2_enable='true' or $burstseq_incr_enable='true' or $burstseq_strm_enable='true' or $burstseq_wrap_enable='true' or $burstseq_xor_enable='true')))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MBurstSingleReq']) and ($burstsinglereq='true' and $burstlength='true' and ($datahandshake='true' or not($write_enable='true' or $writenonpost_enable='true' or $rdlwrc_enable='true')) and not($burstseq_unkn_enable='true' and not($burstseq_blck_enable='true' or $burstseq_dflt1_enable='true' or $burstseq_dflt2_enable='true' or $burstseq_incr_enable='true' or $burstseq_strm_enable='true' or $burstseq_wrap_enable='true' or $burstseq_xor_enable='true'))))">
        <xsl:text>  Port presence constraint is not verified for port MBurstSingleReq</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MDataLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataLast']) and not($datalast='true' and $burstlength='true' and $datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataLast']) and ($datalast='true' and $burstlength='true' and $datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port MDataLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MDataRowLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataRowLast']) and not($datarowlast='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true' and $datahandshake='true' and $datalast='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataRowLast']) and ($datarowlast='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true' and $datahandshake='true' and $datalast='true'))">
        <xsl:text>  Port presence constraint is not verified for port MDataRowLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MReqLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqLast']) and not($reqlast='true' and $burstlength='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqLast']) and ($reqlast='true' and $burstlength='true'))">
        <xsl:text>  Port presence constraint is not verified for port MReqLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MReqRowLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqRowLast']) and not($reqlast='true' and $reqrowlast='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReqRowLast']) and ($reqlast='true' and $reqrowlast='true' and $burstlength='true' and $burstseq_blck_enable='true' and $burstprecise='true'))">
        <xsl:text>  Port presence constraint is not verified for port MReqRowLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SRespLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespLast']) and not($resplast='true' and $burstlength='true' and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespLast']) and ($resplast='true' and $burstlength='true' and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port SRespLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SRespRowLast -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespRowLast']) and not($resplast='true' and $resprowlast='true' and $burstlength='true' and $resp='true' and $burstseq_blck_enable='true' and $burstprecise='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SRespRowLast']) and ($resplast='true' and $resprowlast='true' and $burstlength='true' and $resp='true' and $burstseq_blck_enable='true' and $burstprecise='true'))">
        <xsl:text>  Port presence constraint is not verified for port SRespRowLast</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MDataTagID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataTagID']) and not(($tags > 1) and $datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataTagID']) and (($tags > 1) and $datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port MDataTagID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataTagID']">
        <xsl:variable name="idportWidthx1x1094_0">
          <xsl:if test="not($tags='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$tags"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MDataTagID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="($tags) and not(ceiling($idportWidthx1x1094_0) >= $portLeft - $portRight + 1 )">
          <xsl:text>  Port width constraint is not verified for port MDataTagID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MTagID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MTagID']) and not($tags > 1)) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MTagID']) and ($tags > 1))">
        <xsl:text>  Port presence constraint is not verified for port MTagID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MTagID']">
        <xsl:variable name="idportWidthx1x1128_0">
          <xsl:if test="not($tags='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$tags"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MTagID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="($tags) and not(ceiling($idportWidthx1x1128_0) >= $portLeft - $portRight + 1 )">
          <xsl:text>  Port width constraint is not verified for port MTagID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MTagInOrder -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MTagInOrder']) and not($taginorder='true' and ($tags > 1))) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MTagInOrder']) and ($taginorder='true' and ($tags > 1)))">
        <xsl:text>  Port presence constraint is not verified for port MTagInOrder</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port STagID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='STagID']) and not(($tags > 1) and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='STagID']) and (($tags > 1) and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port STagID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='STagID']">
        <xsl:variable name="idportWidthx1x1190_0">
          <xsl:if test="not($tags='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$tags"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='STagID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="($tags) and not(ceiling($idportWidthx1x1190_0) >= $portLeft - $portRight + 1 )">
          <xsl:text>  Port width constraint is not verified for port STagID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port STagInOrder -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='STagInOrder']) and not($taginorder='true' and ($tags > 1) and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='STagInOrder']) and ($taginorder='true' and ($tags > 1) and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port STagInOrder</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MConnID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MConnID']) and not($connid='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MConnID']) and ($connid='true'))">
        <xsl:text>  Port presence constraint is not verified for port MConnID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MConnID']) and $connid_wdth=''">
        <xsl:text>  Parameter connid_wdth should be present to check port width constraint on port MConnID.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MConnID']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MConnID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($connid_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MConnID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MDataThreadID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataThreadID']) and not(($threads > 1) and $datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataThreadID']) and (($threads > 1) and $datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port MDataThreadID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MDataThreadID']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MDataThreadID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($threads = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MDataThreadID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MThreadBusy -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadBusy']) and not($mthreadbusy='true' and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadBusy']) and ($mthreadbusy='true' and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port MThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadBusy']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MThreadBusy']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($threads = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MThreadID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadID']) and not($threads > 1)) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadID']) and ($threads > 1))">
        <xsl:text>  Port presence constraint is not verified for port MThreadID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MThreadID']">
        <xsl:variable name="idportWidthx1x1350_0">
          <xsl:if test="not($threads='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$threads"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MThreadID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="($threads) and not(ceiling($idportWidthx1x1350_0) >= $portLeft - $portRight + 1 )">
          <xsl:text>  Port width constraint is not verified for port MThreadID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SDataThreadBusy -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataThreadBusy']) and not($sdatathreadbusy='true' and $datahandshake='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataThreadBusy']) and ($sdatathreadbusy='true' and $datahandshake='true'))">
        <xsl:text>  Port presence constraint is not verified for port SDataThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SDataThreadBusy']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SDataThreadBusy']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($threads = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SDataThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SThreadBusy -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadBusy']) and not($sthreadbusy='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadBusy']) and ($sthreadbusy='true'))">
        <xsl:text>  Port presence constraint is not verified for port SThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadBusy']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SThreadBusy']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($threads = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SThreadBusy</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SThreadID -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadID']) and not(($threads > 1) and $resp='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadID']) and (($threads > 1) and $resp='true'))">
        <xsl:text>  Port presence constraint is not verified for port SThreadID</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SThreadID']">
        <xsl:variable name="idportWidthx1x1439_0">
          <xsl:if test="not($threads='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$threads"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SThreadID']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="($threads) and not(ceiling($idportWidthx1x1439_0) >= $portLeft - $portRight + 1 )">
          <xsl:text>  Port width constraint is not verified for port SThreadID</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MError -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MError']) and not($merror='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MError']) and ($merror='true'))">
        <xsl:text>  Port presence constraint is not verified for port MError</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port MFlag -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MFlag']) and not($mflag='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MFlag']) and ($mflag='true'))">
        <xsl:text>  Port presence constraint is not verified for port MFlag</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MFlag']) and $mflag_wdth=''">
        <xsl:text>  Parameter mflag_wdth should be present to check port width constraint on port MFlag.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MFlag']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='MFlag']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($mflag_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port MFlag</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port MReset_n -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReset_n']) and $mreset=''">
        <xsl:text>  Parameter mreset should be present to check presence constraint on port MReset_n.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReset_n']) and not($mreset='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='MReset_n']) and ($mreset='true'))">
        <xsl:text>  Port presence constraint is not verified for port MReset_n</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SError -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SError']) and not($serror='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SError']) and ($serror='true'))">
        <xsl:text>  Port presence constraint is not verified for port SError</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SFlag -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SFlag']) and not($sflag='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SFlag']) and ($sflag='true'))">
        <xsl:text>  Port presence constraint is not verified for port SFlag</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SFlag']) and $sflag_wdth=''">
        <xsl:text>  Parameter sflag_wdth should be present to check port width constraint on port SFlag.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SFlag']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='SFlag']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($sflag_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port SFlag</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port SInterrupt -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SInterrupt']) and not($interrupt='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SInterrupt']) and ($interrupt='true'))">
        <xsl:text>  Port presence constraint is not verified for port SInterrupt</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port SReset_n -->
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SReset_n']) and $sreset=''">
        <xsl:text>  Parameter sreset should be present to check presence constraint on port SReset_n.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SReset_n']) and not($sreset='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='SReset_n']) and ($sreset='true'))">
        <xsl:text>  Port presence constraint is not verified for port SReset_n</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port Control -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Control']) and not($control='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Control']) and ($control='true'))">
        <xsl:text>  Port presence constraint is not verified for port Control</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Control']) and $control_wdth=''">
        <xsl:text>  Parameter control_wdth should be present to check port width constraint on port Control.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Control']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='Control']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($control_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port Control</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port ControlBusy -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ControlBusy']) and not($controlbusy='true' and $control='true' and $controlwr='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ControlBusy']) and ($controlbusy='true' and $control='true' and $controlwr='true'))">
        <xsl:text>  Port presence constraint is not verified for port ControlBusy</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port ControlWr -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ControlWr']) and not($control='true' and $controlwr='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ControlWr']) and ($control='true' and $controlwr='true'))">
        <xsl:text>  Port presence constraint is not verified for port ControlWr</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port Status -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Status']) and not($status='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Status']) and ($status='true'))">
        <xsl:text>  Port presence constraint is not verified for port Status</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Status']) and $status_wdth=''">
        <xsl:text>  Parameter status_wdth should be present to check port width constraint on port Status.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Status']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='Status']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($status_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port Status</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port StatusBusy -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='StatusBusy']) and not($statusbusy='true' and $status='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='StatusBusy']) and ($statusbusy='true' and $status='true'))">
        <xsl:text>  Port presence constraint is not verified for port StatusBusy</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port StatusRd -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='StatusRd']) and not($statusrd='true' and $status='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='StatusRd']) and ($statusrd='true' and $status='true'))">
        <xsl:text>  Port presence constraint is not verified for port StatusRd</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port ClkByp -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ClkByp']) and not($clkctrl_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='ClkByp']) and ($clkctrl_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port ClkByp</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port Scanctrl -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanctrl']) and not($scanport='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanctrl']) and ($scanport='true'))">
        <xsl:text>  Port presence constraint is not verified for port Scanctrl</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanctrl']) and $scanctrl_wdth=''">
        <xsl:text>  Parameter scanctrl_wdth should be present to check port width constraint on port Scanctrl.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanctrl']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='Scanctrl']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($scanctrl_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port Scanctrl</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port Scanin -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanin']) and not($scanport='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanin']) and ($scanport='true'))">
        <xsl:text>  Port presence constraint is not verified for port Scanin</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanin']) and $scanport_wdth=''">
        <xsl:text>  Parameter scanport_wdth should be present to check port width constraint on port Scanin.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanin']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='Scanin']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($scanport_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port Scanin</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port Scanout -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanout']) and not($scanport='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanout']) and ($scanport='true'))">
        <xsl:text>  Port presence constraint is not verified for port Scanout</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanout']) and $scanport_wdth=''">
        <xsl:text>  Parameter scanport_wdth should be present to check port width constraint on port Scanout.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='Scanout']">
        <xsl:variable name="portName">
          <xsl:value-of select="spirit:portMaps/spirit:portMap[spirit:logicalPort/spirit:name='Scanout']/spirit:physicalPort/spirit:name"/>
        </xsl:variable>
        <xsl:variable name="portLeft">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:left"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="portRight">
          <xsl:choose>
            <xsl:when test="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right">
              <xsl:value-of select="/spirit:component/spirit:model/spirit:ports/spirit:port[spirit:name=$portName]/spirit:wire/spirit:vector/spirit:right"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>0</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:if test="not($scanport_wdth = $portLeft - $portRight + 1)">
          <xsl:text>  Port width constraint is not verified for port Scanout</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      </xsl:if>
      <!-- Tests for logical port TCK -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TCK']) and not($jtag_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TCK']) and ($jtag_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TCK</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port TDI -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TDI']) and not($jtag_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TDI']) and ($jtag_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TDI</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port TDO -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TDO']) and not($jtag_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TDO']) and ($jtag_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TDO</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port TestClk -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TestClk']) and not($clkctrl_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TestClk']) and ($clkctrl_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TestClk</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port TMS -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TMS']) and not($jtag_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TMS']) and ($jtag_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TMS</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Tests for logical port TRST_N -->
      <xsl:if test="((spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TRST_N']) and not($jtagtrst_enable='true' and $jtag_enable='true')) or (not(spirit:portMaps/spirit:portMap/spirit:logicalPort[spirit:name='TRST_N']) and ($jtagtrst_enable='true' and $jtag_enable='true'))">
        <xsl:text>  Port presence constraint is not verified for port TRST_N</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <!-- Test for parameter broadcast_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$broadcast_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burst_aligned and assertion request_cfg_burst_aligned_enable_burstlength -->
        <xsl:if test="$burst_aligned='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_burst_aligned_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burst_aligned and assertion request_cfg_burst_aligned_enable_burstseq_enable -->
        <xsl:if test="$burst_aligned='true'">
        <xsl:if test="not($burstseq_incr_enable='true' or 
                                $burstseq='false')">
          <xsl:text>  Assertion request_cfg_burst_aligned_enable_burstseq_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstseq_unkn_enable and assertion request_cfg_burstsinglereq_enable_burstseq_enable -->
        <xsl:if test="$burstseq_unkn_enable='true'">
        <xsl:if test="not($burstseq_unkn_enable='false' or 
                                $burstseq_blck_enable=true or 
                                $burstseq_dflt1_enable=true or 
                                $burstseq_dflt2_enable=true or 
                                $burstseq_incr_enable=true or 
                                $burstseq_strm_enable=true or 
                                $burstseq_wrap_enable=true or 
                                $burstseq_xor_enable=true)">
          <xsl:text>  Assertion request_cfg_burstsinglereq_enable_burstseq_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter force_aligned and assertion request_cfg_force_aligned_enable_data_wdth -->
        <xsl:if test="$force_aligned='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:variable name="idvaluex4x215_0">
          <xsl:if test="not(
                                $data_wdth='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="
                                $data_wdth"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:if test="
                                $data_wdth=''">
          <xsl:text>  Parameter data_wdth should be present</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        <xsl:variable name="idvaluex4x215_1">
          <xsl:if test="not(
                                $data_wdth='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="
                                $data_wdth"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:if test="
                                $data_wdth=''">
          <xsl:text>  Parameter data_wdth should be present</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        <xsl:if test="(
                                $data_wdth) and not($idvaluex4x215_0 = round($idvaluex4x215_1))">
          <xsl:text>  Assertion request_cfg_force_aligned_enable_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mthreadbusy_exact and assertion response_cfg_mthreadbusy_exact_enable_mthreadbusy -->
        <xsl:if test="$mthreadbusy_exact='true'">
        <xsl:if test="not($mthreadbusy='true')">
          <xsl:text>  Assertion response_cfg_mthreadbusy_exact_enable_mthreadbusy is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter rdlwrc_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$rdlwrc_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter rdlwrc_enable and assertion response_cfg_rdlwrc_enable_enable_writeresp_enable -->
        <xsl:if test="$rdlwrc_enable='true'">
        <xsl:if test="not($writeresp_enable='true')">
          <xsl:text>  Assertion response_cfg_rdlwrc_enable_enable_writeresp_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter read_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$read_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter read_enable and assertion response_cfg_read_enable_enable_resp -->
        <xsl:if test="$read_enable='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_read_enable_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter readex_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$readex_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter readex_enable and assertion request_cfg_readex_enable_write_writenonpost -->
        <xsl:if test="$readex_enable='true'">
        <xsl:if test="not($write_enable='true' or 
                                $writenonpost_enable='true')">
          <xsl:text>  Assertion request_cfg_readex_enable_write_writenonpost is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatathreadbusy_exact and assertion datahandshake_cfg_sdatathreadbusy_exact_enable_sdatathreadbusy -->
        <xsl:if test="$sdatathreadbusy_exact='true'">
        <xsl:if test="not($sdatathreadbusy='true')">
          <xsl:text>  Assertion datahandshake_cfg_sdatathreadbusy_exact_enable_sdatathreadbusy is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sthreadbusy_exact and assertion request_cfg_sthreadbusy_exact_enable_sthreadBusy -->
        <xsl:if test="$sthreadbusy_exact='true'">
        <xsl:if test="not($sthreadbusy='true')">
          <xsl:text>  Assertion request_cfg_sthreadbusy_exact_enable_sthreadBusy is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter tag_interleave_size and assertion request_cfg_tag_interleave_size_depends_burstlength_wdth -->
        <xsl:variable name="idvaluex4x427_0">
          <xsl:if test="not(
                                $tag_interleave_size='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="
                                $tag_interleave_size"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="idvaluex4x427_1">
          <xsl:if test="not(
                                $tag_interleave_size='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="
                                $tag_interleave_size"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:variable name="idvaluex4x427_2">
          <xsl:if test="not($burstlength_wdth='')">
            <xsl:call-template name="pow">
              <xsl:with-param name="number"><xsl:value-of select="
                                $burstlength_wdth - 1"/></xsl:with-param>
              <xsl:with-param name="power"><xsl:value-of select="2"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:if test="(
                                $tag_interleave_size and $burstlength_wdth) and not(((
                                $tag_interleave_size = 1) and 
                                $burstlength_wdth = 0) or 
                                $tag_interleave_size = 0 or (
                                $tag_interleave_size > 1 and ($idvaluex4x427_0 = round($idvaluex4x427_1)) and ($idvaluex4x427_2 >= 
                                $tag_interleave_size)))">
          <xsl:text>  Assertion request_cfg_tag_interleave_size_depends_burstlength_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      <!-- Test for parameter write_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$write_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter writenonpost_enable and assertion request_cfg_cmd_enable -->
        <xsl:if test="$writenonpost_enable='true'">
        <xsl:if test="not($read_enable='true' or 
                                $readex_enable='true' or 
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $broadcast_enable='true' or 
                                $rdlwrc_enable='true')">
          <xsl:text>  Assertion request_cfg_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter writenonpost_enable and assertion response_cfg_writenonpost_enable_enable_writeresp_enable -->
        <xsl:if test="$writenonpost_enable='true'">
        <xsl:if test="not($writeresp_enable='true')">
          <xsl:text>  Assertion response_cfg_writenonpost_enable_enable_writeresp_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datahandshake and assertion datahandshake_cfg_datahandshake_enable_mdata -->
        <xsl:if test="$datahandshake='true'">
        <xsl:if test="not($mdata='true')">
          <xsl:text>  Assertion datahandshake_cfg_datahandshake_enable_mdata is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqdata_together and assertion request_cfg_reqdata_together_enable_burstsinglereq -->
        <xsl:if test="$reqdata_together='true'">
        <xsl:if test="not($burstsinglereq='true')">
          <xsl:text>  Assertion request_cfg_reqdata_together_enable_burstsinglereq is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqdata_together and assertion request_cfg_reqdata_together_enable_cmdaccept_dataaccept -->
        <xsl:if test="$reqdata_together='true'">
        <xsl:if test="not(not ((
                                $cmdaccept='true' and not (
                                $dataaccept='true')) or (not (
                                $cmdaccept='true') and 
                                $dataaccept='true')))">
          <xsl:text>  Assertion request_cfg_reqdata_together_enable_cmdaccept_dataaccept is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqdata_together and assertion datahandshake_cfg_reqdata_together_enable_datahandshake -->
        <xsl:if test="$reqdata_together='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_reqdata_together_enable_datahandshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter writeresp_enable and assertion response_cfg_writeresp_enable_enable_resp -->
        <xsl:if test="$writeresp_enable='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_writeresp_enable_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter addr_wdth and assertion request_cfg_addr_width_depends_data_wdth -->
        <xsl:if test="$addr='true'">
      <xsl:if test="$addr_wdth=''">
        <xsl:text>  Parameter addr_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:variable name="_0">
          <xsl:if test="not($data_wdth='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="$data_wdth"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:if test="$data_wdth=''">
          <xsl:text>  Parameter data_wdth should be present</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        <xsl:variable name="_1">
            <xsl:call-template name="max">
              <xsl:with-param name="number1"><xsl:value-of select=" ceiling($_0) - 3"/></xsl:with-param>
              <xsl:with-param name="number2"><xsl:value-of select="1"/></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="($data_wdth) and not($addr_wdth >= $_1)">
          <xsl:text>  Assertion request_cfg_addr_width_depends_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter atomiclength and assertion request_cfg_atomiclength_enable_burstlength -->
        <xsl:if test="$atomiclength='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_atomiclength_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter atomiclength_wdth and assertion request_cfg_atomiclength_wdth_depends_burstlengthwdth -->
        <xsl:if test="$burstlength='true' and 
                                $atomiclength='true'">
      <xsl:if test="$atomiclength_wdth=''">
        <xsl:text>  Parameter atomiclength_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not((
                                $burstlength_wdth >= 
                                $atomiclength_wdth) ='true')">
          <xsl:text>  Assertion request_cfg_atomiclength_wdth_depends_burstlengthwdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter blockheight and assertion request_cfg_blockheight_enable_burstseq_blck_enable -->
        <xsl:if test="$blockheight='true'">
        <xsl:if test="not($burstseq_blck_enable='true')">
          <xsl:text>  Assertion request_cfg_blockheight_enable_burstseq_blck_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter blockheight_wdth and assertion request_cfg_value_blockheight_wdth_0x1 -->
        <xsl:if test="not((
                                $blockheight='false' and  
                                $blockheight_wdth = 0) or (
                                $blockheight='true' and 
                                $blockheight_wdth > 1))">
          <xsl:text>  Assertion request_cfg_value_blockheight_wdth_0x1 is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      <!-- Test for parameter blockstride and assertion request_cfg_blockstride_enable_burstseq_blck_enable -->
        <xsl:if test="$blockstride='true'">
        <xsl:if test="not($burstseq_blck_enable='true')">
          <xsl:text>  Assertion request_cfg_blockstride_enable_burstseq_blck_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstlength and assertion request_cfg_burstlength_enable_burstseq_enable -->
        <xsl:if test="$burstlength='true'">
        <xsl:if test="not($burstseq_blck_enable='true' or 
                                $burstseq_dflt1_enable='true' or 
                                $burstseq_dflt2_enable='true' or 
                                $burstseq_incr_enable='true' or 
                                $burstseq_strm_enable='true' or 
                                $burstseq_unkn_enable='true' or 
                                $burstseq_wrap_enable='true' or 
                                $burstseq_xor_enable='true')">
          <xsl:text>  Assertion request_cfg_burstlength_enable_burstseq_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstlength_wdth and assertion request_cfg_value_burstlength_wdth_0x1 -->
        <xsl:if test="not((
                                $burstlength='false' and 
                                $burstlength_wdth = 0) or (
                                $burstlength='true' and 
                                $burstlength_wdth > 1))">
          <xsl:text>  Assertion request_cfg_value_burstlength_wdth_0x1 is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
      <!-- Test for parameter burstprecise and assertion request_cfg_burstprecise_enable_burstlength -->
        <xsl:if test="$burstprecise='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_burstprecise_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstprecise and assertion request_cfg_burstprecise_enable_burstseq_enable -->
        <xsl:if test="$burstprecise='true'">
        <xsl:if test="not((
                                $burstprecise='true' and (
                                $burstseq_blck_enable='true' or 
                                $burstseq_wrap_enable='true' or 
                                $burstseq_xor_enable='true') and (
                                $burstseq_dflt1_enable='true' or 
                                $burstseq_dflt2_enable='true' or 
                                $burstseq_incr_enable='true' or 
                                $burstseq_strm_enable='true' or 
                                $burstseq_unkn_enable='true')) or (not(
                                $burstprecise='true') and (
                                $burstseq_blck_enable='true' or 
                                $burstseq_wrap_enable='true' or 
                                $burstseq_xor_enable='true') and not(
                                $burstseq_dflt1_enable='true' or 
                                $burstseq_dflt2_enable='true' or 
                                $burstseq_incr_enable='true' or 
                                $burstseq_strm_enable='true' or 
                                $burstseq_unkn_enable='true')) or (
                                $burstprecise='false' and 
                                $burstseq_blck_enable='false' and 
                                $burstseq_wrap_enable='false' and 
                                $burstseq_xor_enable='false' and 
                                $burstseq_dflt1_enable='false' and 
                                $burstseq_dflt2_enable='false' and 
                                $burstseq_incr_enable='false' and 
                                $burstseq_strm_enable='false' and 
                                $burstseq_unkn_enable='false'))">
          <xsl:text>  Assertion request_cfg_burstprecise_enable_burstseq_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstseq and assertion request_cfg_burstseq_enable_burstlength -->
        <xsl:if test="$burstseq='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_burstseq_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstseq and assertion request_cfg_burstseq_enable_addr -->
        <xsl:if test="$burstseq='true'">
        <xsl:if test="not($addr='true')">
          <xsl:text>  Assertion request_cfg_burstseq_enable_addr is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstsinglereq and assertion request_cfg_burstsinglereq_enable_burstlength -->
        <xsl:if test="$burstsinglereq='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_burstsinglereq_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstsinglereq and assertion request_cfg_burstsinglereq_enable_burstprecise -->
        <xsl:if test="$burstsinglereq='true'">
        <xsl:if test="not($burstprecise='true')">
          <xsl:text>  Assertion request_cfg_burstsinglereq_enable_burstprecise is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter burstsinglereq and assertion request_cfg_burstsinglereq_enable_datahandshake_cmd_enable -->
        <xsl:if test="$burstsinglereq='true'">
        <xsl:if test="not($datahandshake='true' or not(
                                $write_enable='true' or 
                                $writenonpost_enable='true' or 
                                $rdlwrc_enable))">
          <xsl:text>  Assertion request_cfg_burstsinglereq_enable_datahandshake_cmd_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter byteen and assertion request_cfg_byteen_enable_mdata_sdata -->
        <xsl:if test="$byteen='true'">
        <xsl:if test="not($sdata='true' or 
                                $mdata='true')">
          <xsl:text>  Assertion request_cfg_byteen_enable_mdata_sdata is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter byteen and assertion request_cfg_byteen_enable_data_wdth -->
        <xsl:if test="$byteen='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not((
                                $data_wdth mod 8) = 0)">
          <xsl:text>  Assertion request_cfg_byteen_enable_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter connid_wdth and assertion connid_minimum_wdth -->
        <xsl:if test="$connid='true'">
      <xsl:if test="$connid_wdth=''">
        <xsl:text>  Parameter connid_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($connid_wdth >= 1)">
          <xsl:text>  Assertion connid_minimum_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter dataaccept and assertion datahandshake_cfg_dataaccept_enable_datahandshake -->
        <xsl:if test="$dataaccept='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_dataaccept_enable_datahandshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter dataaccept and assertion datahandshake_cfg_dataaccept_enable_sdatathreadbusy_exact -->
        <xsl:if test="$dataaccept='true'">
        <xsl:if test="not(not(
                                $sdatathreadbusy_exact='true'))">
          <xsl:text>  Assertion datahandshake_cfg_dataaccept_enable_sdatathreadbusy_exact is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datalast and assertion datahandshake_cfg_datalast_enable_burstlength -->
        <xsl:if test="$datalast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion datahandshake_cfg_datalast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datalast and assertion datahandshake_cfg_datalast_enable_datahandshake -->
        <xsl:if test="$datalast='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_datalast_enable_datahandshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datarowlast and assertion datahandshake_cfg_datarowlast_enable_datahandshake -->
        <xsl:if test="$datarowlast='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_datarowlast_enable_datahandshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datarowlast and assertion datahandshake_cfg_datrowalast_enable_burstlength -->
        <xsl:if test="$datarowlast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion datahandshake_cfg_datrowalast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter datarowlast and assertion datahandshake_cfg_datarowlast_enable_datalast_burstseq_blck_enable -->
        <xsl:if test="$datarowlast='true'">
        <xsl:if test="not($datalast='true' and 
                                $burstseq_blck_enable='true')">
          <xsl:text>  Assertion datahandshake_cfg_datarowlast_enable_datalast_burstseq_blck_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter data_wdth and assertion request_cfg_addr_width_depends_data_wdth -->
        <xsl:if test="$mdata='true' or 
                                $sdata='true'">
      <xsl:if test="$addr_wdth=''">
        <xsl:text>  Parameter addr_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:variable name="_0">
          <xsl:if test="not(
                                $data_wdth='')">
            <xsl:call-template name="log2">
              <xsl:with-param name="number"><xsl:value-of select="
                                $data_wdth"/></xsl:with-param>
              <xsl:with-param name="result">0</xsl:with-param>
            </xsl:call-template>
          </xsl:if>
        </xsl:variable>
        <xsl:if test="
                                $data_wdth=''">
          <xsl:text>  Parameter data_wdth should be present</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        <xsl:variable name="_1">
            <xsl:call-template name="max">
              <xsl:with-param name="number1"><xsl:value-of select=" ceiling($_0) - 3"/></xsl:with-param>
              <xsl:with-param name="number2"><xsl:value-of select="1"/></xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:if test="(
                                $data_wdth) and not($addr_wdth >= $_1)">
          <xsl:text>  Assertion request_cfg_addr_width_depends_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter data_wdth and assertion data_wdth_minimum_value -->
        <xsl:if test="$mdata='true' or 
                                $sdata='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($data_wdth > 1)">
          <xsl:text>  Assertion data_wdth_minimum_value is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatabyteen and assertion datahandshake_cfg_mdatabyteen_enable_datahanshake -->
        <xsl:if test="$mdatabyteen='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_mdatabyteen_enable_datahanshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatabyteen and assertion datahandshake_cfg_mdatabyteen_enable_mdata -->
        <xsl:if test="$mdatabyteen='true'">
        <xsl:if test="not($mdata='true')">
          <xsl:text>  Assertion datahandshake_cfg_mdatabyteen_enable_mdata is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatabyteen and assertion datahandshake_cfg_mdatabyteen_depends_data_wdth -->
        <xsl:if test="$mdatabyteen='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not((
                                $data_wdth mod 8) = 0)">
          <xsl:text>  Assertion datahandshake_cfg_mdatabyteen_depends_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatainfo and assertion request_cfg_mdatainfo_enable_mdata -->
        <xsl:if test="$mdatainfo='true'">
        <xsl:if test="not($mdata='true')">
          <xsl:text>  Assertion request_cfg_mdatainfo_enable_mdata is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatainfo and assertion datahandshake_cfg_mdatainfo_depends_data_wdth -->
        <xsl:if test="$mdatainfo='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not((
                                $data_wdth mod 8) = 0)">
          <xsl:text>  Assertion datahandshake_cfg_mdatainfo_depends_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mdatainfo_wdth and assertion datahandshake_cfg_mdatainfo_wdth_depends_mdatainfobyte_wdth -->
        <xsl:if test="$mdatainfo='true'">
      <xsl:if test="$mdatainfo_wdth=''">
        <xsl:text>  Parameter mdatainfo_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$mdatainfobyte_wdth=''">
        <xsl:text>  Parameter mdatainfobyte_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($mdatainfo_wdth >= 
                                $mdatainfobyte_wdth * 
                                $data_wdth div 8)">
          <xsl:text>  Assertion datahandshake_cfg_mdatainfo_wdth_depends_mdatainfobyte_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mthreadbusy and assertion response_cfg_mthreadbusy_enable_resp -->
        <xsl:if test="$mthreadbusy='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_mthreadbusy_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mthreadbusy and assertion response_cfg_mthreadbusy_enable_mthreadbusy_exact_respaccept -->
        <xsl:if test="$mthreadbusy='true'">
        <xsl:if test="not((
                                $mthreadbusy_exact='true' and not (
                                $respaccept='true')) or (not (
                                $mthreadbusy_exact='true') and 
                                $respaccept='true'))">
          <xsl:text>  Assertion response_cfg_mthreadbusy_enable_mthreadbusy_exact_respaccept is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mthreadbusy_pipelined and assertion request_cfg_mthreadbusy_pipelined_enable_mthreadbusy_exact -->
        <xsl:if test="$mthreadbusy_pipelined='true'">
        <xsl:if test="not($mthreadbusy_exact='true')">
          <xsl:text>  Assertion request_cfg_mthreadbusy_pipelined_enable_mthreadbusy_exact is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqlast and assertion request_cfg_reqlast_enable_burstlength -->
        <xsl:if test="$reqlast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_reqlast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqrowlast and assertion request_cfg_reqrowlast_enable_burstlength -->
        <xsl:if test="$reqrowlast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion request_cfg_reqrowlast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter reqrowlast and assertion request_cfg_reqrowlast_enable_reqlast_burstseq_blck_enable -->
        <xsl:if test="$reqrowlast='true'">
        <xsl:if test="not($reqlast='true' and 
                                $burstseq_blck_enable='true')">
          <xsl:text>  Assertion request_cfg_reqrowlast_enable_reqlast_burstseq_blck_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter respaccept and assertion response_cfg_respaccept_enable_resp -->
        <xsl:if test="$respaccept='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_respaccept_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter respaccept and assertion response_cfg_respaccept_enable_mthreadbusy_exact -->
        <xsl:if test="$respaccept='true'">
        <xsl:if test="not(not(
                                $mthreadbusy_exact='true'))">
          <xsl:text>  Assertion response_cfg_respaccept_enable_mthreadbusy_exact is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter respinfo and assertion response_cfg_respinfo_enable_resp -->
        <xsl:if test="$respinfo='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_respinfo_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter resplast and assertion response_cfg_resplast_enable_burstlength -->
        <xsl:if test="$resplast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion response_cfg_resplast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter resplast and assertion response_cfg_resplast_enable_resp -->
        <xsl:if test="$resplast='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_resplast_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter resprowlast and assertion response_cfg_resprowlast_enable_resp -->
        <xsl:if test="$resprowlast='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_resprowlast_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter resprowlast and assertion response_cfg_resprowlast_enable_burstlength -->
        <xsl:if test="$resprowlast='true'">
        <xsl:if test="not($burstlength='true')">
          <xsl:text>  Assertion response_cfg_resprowlast_enable_burstlength is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter resprowlast and assertion response_cfg_resprowlast_enable_resplast_burstseq_blck_enable -->
        <xsl:if test="$resprowlast='true'">
        <xsl:if test="not($resplast='true' and 
                                $burstseq_blck_enable='true')">
          <xsl:text>  Assertion response_cfg_resprowlast_enable_resplast_burstseq_blck_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdata and assertion request_cfg_sdata_enable_resp -->
        <xsl:if test="$sdata='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion request_cfg_sdata_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatainfo and assertion request_cfg_sdatainfo_enable_sdata -->
        <xsl:if test="$sdatainfo='true'">
        <xsl:if test="not($sdata='true')">
          <xsl:text>  Assertion request_cfg_sdatainfo_enable_sdata is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatainfo and assertion datahandshake_cfg_sdatainfo_depends_data_wdth -->
        <xsl:if test="$sdatainfo='true'">
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not((
                                $data_wdth mod 8) = 0)">
          <xsl:text>  Assertion datahandshake_cfg_sdatainfo_depends_data_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatainfo and assertion response_cfg_sdatainfo_enable_resp -->
        <xsl:if test="$sdatainfo='true'">
        <xsl:if test="not($resp='true')">
          <xsl:text>  Assertion response_cfg_sdatainfo_enable_resp is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatainfo_wdth and assertion datahandshake_cfg_sdatainfo_wdth_depends_sdatainfobyte_wdth -->
        <xsl:if test="$sdatainfo='true'">
      <xsl:if test="$sdatainfo_wdth=''">
        <xsl:text>  Parameter sdatainfo_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$sdatainfobyte_wdth=''">
        <xsl:text>  Parameter sdatainfobyte_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$data_wdth=''">
        <xsl:text>  Parameter data_wdth should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($sdatainfo_wdth >= 
                                $sdatainfobyte_wdth * 
                                $data_wdth div 8)">
          <xsl:text>  Assertion datahandshake_cfg_sdatainfo_wdth_depends_sdatainfobyte_wdth is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatathreadbusy and assertion datahandshake_cfg_sdatathreadbusy_enable_datahanshake -->
        <xsl:if test="$sdatathreadbusy='true'">
        <xsl:if test="not($datahandshake='true')">
          <xsl:text>  Assertion datahandshake_cfg_sdatathreadbusy_enable_datahanshake is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatathreadbusy and assertion  -->
        <xsl:if test="$sdatathreadbusy='true'">
        <xsl:if test="not($sdatathreadbusy_exact='true')">
          <xsl:text>  Assertion  is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sdatathreadbusy_pipelined and assertion request_cfg_sdatathreadbusy_pipelined_enable_sdatathreadbusy_exact> -->
        <xsl:if test="$sdatathreadbusy_pipelined='true'">
        <xsl:if test="not($sdatathreadbusy_exact='true')">
          <xsl:text>  Assertion request_cfg_sdatathreadbusy_pipelined_enable_sdatathreadbusy_exact> is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sthreadbusy and assertion request_cfg_sthreadbusy_enable_sthreadbusy_exact_cmdaccept -->
        <xsl:if test="$sthreadbusy='true'">
        <xsl:if test="not($sthreadbusy_exact='true' or 
                                $cmdaccept='true')">
          <xsl:text>  Assertion request_cfg_sthreadbusy_enable_sthreadbusy_exact_cmdaccept is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sthreadbusy_pipelined and assertion request_cfg_sthreadbusy_pipelined_enable_sthreadbusy_exact -->
        <xsl:if test="$sthreadbusy_pipelined='true'">
        <xsl:if test="not($sthreadbusy_exact='true')">
          <xsl:text>  Assertion request_cfg_sthreadbusy_pipelined_enable_sthreadbusy_exact is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter taginorder and assertion request_cfg_taginorder_enable_tags -->
        <xsl:if test="$taginorder='true'">
        <xsl:if test="not($tags > 1)">
          <xsl:text>  Assertion request_cfg_taginorder_enable_tags is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter controlbusy and assertion sideband_cfg_controlbusy_enable_control -->
        <xsl:if test="$controlbusy='true'">
        <xsl:if test="not($control='true')">
          <xsl:text>  Assertion sideband_cfg_controlbusy_enable_control is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter controlbusy and assertion sideband_cfg_controlbusy_enable_controlwr -->
        <xsl:if test="$controlbusy='true'">
        <xsl:if test="not($controlwr='true')">
          <xsl:text>  Assertion sideband_cfg_controlbusy_enable_controlwr is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter controlwr and assertion sideband_cfg_controlwr_enable_control -->
        <xsl:if test="$controlwr='true'">
        <xsl:if test="not($control='true')">
          <xsl:text>  Assertion sideband_cfg_controlwr_enable_control is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter mreset and assertion sideband_cfg_mreset_sreset -->
        <xsl:if test="$mreset='true'">
      <xsl:if test="$mreset=''">
        <xsl:text>  Parameter mreset should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$sreset=''">
        <xsl:text>  Parameter sreset should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($mreset='true' or 
                                $sreset='true')">
          <xsl:text>  Assertion sideband_cfg_mreset_sreset is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter sreset and assertion sideband_cfg_mreset_sreset -->
        <xsl:if test="$sreset='true'">
      <xsl:if test="$mreset=''">
        <xsl:text>  Parameter mreset should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
      <xsl:if test="$sreset=''">
        <xsl:text>  Parameter sreset should be present.</xsl:text><xsl:call-template name="insertCR"/>
      </xsl:if>
        <xsl:if test="not($mreset='true' or 
                                $sreset='true')">
          <xsl:text>  Assertion sideband_cfg_mreset_sreset is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter statusbusy and assertion sideband_cfg_statusbusy_enable_status -->
        <xsl:if test="$statusbusy='true'">
        <xsl:if test="not($status='true')">
          <xsl:text>  Assertion sideband_cfg_statusbusy_enable_status is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter statusrd and assertion sideband_cfg_statusrd_enable_status -->
        <xsl:if test="$statusrd='true'">
        <xsl:if test="not($status='true')">
          <xsl:text>  Assertion sideband_cfg_statusrd_enable_status is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
      <!-- Test for parameter jtagtrst_enable and assertion test_cfg_jtagreset_enable_jtag_enable -->
        <xsl:if test="$jtagtrst_enable='true'">
        <xsl:if test="not($jtag_enable='true')">
          <xsl:text>  Assertion test_cfg_jtagreset_enable_jtag_enable is not verified</xsl:text><xsl:call-template name="insertCR"/>
        </xsl:if>
        </xsl:if>
    </xsl:for-each>
  </xsl:template>
<xsl:template match="spirit14:component">
<xsl:text> Incompatible spirit namespace </xsl:text>
<xsl:text> Provide IEEE1685-2009 compliant file </xsl:text>
</xsl:template>
</xsl:stylesheet>
