# UVM-SystemC Reference Implementation

### About UVM-SystemC

The UVM-SystemC library provides an implementation of the Universal Verification Methodology (UVM) in SystemC/C++. The UVM-SystemC class library enables the development of scalable and reusable verification collateral for system-level verification and testing. The aim of UVM-SystemC is to be API compatible with UVM in SystemVerilog, to facilitate seamless integration and exchange of Verification IP (VIP) between system-level and IP-level test benches.
  
This version of UVM-SystemC is the reference implementation provided by the [Accellera Systems Initiative][1] and is developed by the [SystemC Verification Working Group][2].

-------------------------------------------------------------------------------

### Licensing and Copyright

See the separate [LICENSE](LICENSE) and [NOTICE](NOTICE) files to determine your rights and responsiblities for using UVM-SystemC.

### User Documentation

The main documentation of UVM-SystemC can be found in the [docs](docs) directory. It contains the Language Reference Manual (LRM) and an introduction presentation. For instructions how to include and use constraint randomization using CRAVE, please refer to [CRAVE][3].

### Installation

See the separate [INSTALL](INSTALL) file that provides system information and installation instructions.

### Release Notes

See the separate [RELEASENOTES](RELEASENOTES) file that provides up-to-date information about this release of SystemC.

### SystemC Verification Community

  * SystemC community website  
    https://systemc.org

  * SystemC Verification discussion forum (UVM-SystemC, SCV, CRAVE, FC4SC)  
    https://forums.accellera.org/forum/38-systemc-verification-uvm-systemc-scv-crave-fc4sc/

-------------------------------------------------------------------------------

### About Accellera SystemC Working Groups

Accellera's [SystemC Working Groups][4] are responsible for the definition and development of the SystemC Core and Transaction Level Modeling (TLM) language, including extensions for analog/mixed-signal (AMS), control, configuration, and inspection (CCI), sythesis and verification. Participants of these working groups include member companies and industry contributors. Technical contributors typically have many years of practical experience with IC and system-level design as well as developing system-level design methodologies and using EDA tools.

### About Accellera Systems Initiative

[Accellera Systems Initiative][1] is an independent, not-for profit organization dedicated to create, support, promote and advance system-level design, modeling and verification standards for use by the worldwide electronics industry.  The organization accelerates standards development and, as part of its ongoing partnership with the IEEE, its standards are contributed to the IEEE Standards Association for formal standardization and ongoing change control. For more information, please visit [www.accellera.org][1]. Find out more about [membership][5]. Follow [@accellera][6] on Twitter or to comment, please use `#accellera`.

_Accellera, Accellera Systems Initiative and SystemC are trademarks of  Accellera Systems Initiative Inc. All other trademarks and trade names are the property of their respective owners._

[1]: https://accellera.org
[2]: https://www.accellera.org/activities/working-groups/systemc-verification
[3]: https://github.com/accellera-official/crave
[4]: https://www.accellera.org/activities/working-groups
[5]: https://accellera.org/about/join/
[6]: https://twitter.com/accellera
