class i2c_monitor extends uvm_monitor; 

  i2c_packet pkt;
  virtual interface i2c_if vif;
  int num_pkt_col;


	uvm_analysis_port#(i2c_packet) item_collected_port;
  `uvm_component_utils(i2c_monitor)

  function new (string name = "i2c_monitor", uvm_component parent);
      super.new(name, parent);
			item_collected_port = new("item_collected_port", this);
  endfunction

  bit [7:0] reg_addr, data;
  bit [6:0] tg_addr;
  bit rw_;
  task run_phase(uvm_phase phase);
    forever begin 
      @(negedge vif.sda iff vif.scl); // wait for start condition
      #1step; //These two lines filter out glitches in vif.sda caused by EEnet conversions
      if ((~vif.sda) && vif.scl) begin
        `uvm_info(get_type_name(), "Start condition detected.", UVM_HIGH)

        `uvm_info(get_type_name(), "Collecting packet ...", UVM_MEDIUM)
        pkt = i2c_packet::type_id::create("pkt");
        void'(begin_tr(pkt, "Monitor_I2C_Packet"));
          vif.collect_pkt(.reg_addr(reg_addr), // write to internal variables in interface
                              .data(data), 
                              .tg_addr(tg_addr), 
                              .rw_(rw_));
          pkt.reg_addr = reg_addr;
          pkt.data = data;
          pkt.tg_addr = tg_addr;
          pkt.rw_ = rw_;
          `uvm_info("i2c_if", "Stop condition has not been detected yet.", UVM_HIGH)
          @(posedge vif.sda iff vif.scl); // wait for stop condition
          `uvm_info(get_type_name(), "Stop condition detected.", UVM_HIGH)
        end_tr(pkt);

        item_collected_port.write(pkt);
        `uvm_info(get_type_name(), "Received transaction", UVM_HIGH)
        `uvm_info(get_type_name(), $sformatf("Packet Collected :\n%s", pkt.sprint()), UVM_MEDIUM)
        num_pkt_col++;
      end
    end
  endtask

  function void report_phase(uvm_phase phase);
    `uvm_info(get_type_name(), $sformatf("Report: I2C Monitor Collected %0d Packets", num_pkt_col), UVM_MEDIUM)
  endfunction 

  function void connect_phase(uvm_phase phase); 
    if (!uvm_config_db#(virtual i2c_if)::get(this, "", "vif", vif))
    `uvm_error("NOVIF", {"vif not set for: ", get_full_name(),".vif"})
  endfunction : connect_phase

  function void start_of_simulation_phase(uvm_phase phase);
    `uvm_info(get_type_name(),"Call i2c_monitor",UVM_HIGH);
  endfunction

endclass
