class i2c_driver extends uvm_driver #(i2c_packet);

  `uvm_component_utils(i2c_driver)

  virtual interface i2c_if vif;

  function new(string name = "i2c_driver", uvm_component parent); 
    super.new(name, parent);
  endfunction

  virtual task run_phase(uvm_phase phase); 
    forever begin 
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), $sformatf("Sending Packet :\n%s", req.sprint()), UVM_MEDIUM)
      void'(begin_tr(req, "Input I2C Packet"));
      vif.send_to_dut(.regAddr(req.reg_addr),
                      .data(req.data),
                      .id(req.tg_addr),
                      .rw_(req.rw_));
      end_tr(req);
      `uvm_info(get_type_name(), "Packet sent", UVM_HIGH)
      seq_item_port.item_done();
    end
  endtask

  function void connect_phase(uvm_phase phase); 
    if (!uvm_config_db#(virtual i2c_if)::get(this, "", "vif", vif))
      `uvm_error("NOVIF", {"vif not set for: ", get_full_name(),".vif"})
  endfunction

  function void start_of_simulation_phase(uvm_phase phase);
    `uvm_info(get_type_name(),"Call i2c_driver",UVM_HIGH);
  endfunction
endclass

class i2c_ms_driver extends i2c_driver;

  `uvm_component_utils(i2c_ms_driver)

  i2c_proxy bridge_proxy;

  rand real Vsup; // supply voltage used by analog resource
  
  //Vsup is too high here
  constraint Vsup_const {Vsup inside {[2.8:3.0]};} 
  
  //Vsup is within limits here
  //constraint Vsup_const {Vsup inside {[1.2:2.4]};} // 1.8V +/- 0.6V
  
  function new(string name = "i2c_ms_driver", uvm_component parent); 
    super.new(name, parent);
  endfunction

  virtual task run_phase(uvm_phase phase); 
    void'(this.randomize());
    bridge_proxy.push_Vsup(Vsup); // set supply voltage in analog resource
    forever begin 
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), $sformatf("Sending Packet :\n%s", req.sprint()), UVM_MEDIUM)
      void'(begin_tr(req, "Input I2C Packet"));
      vif.send_to_dut(.regAddr(req.reg_addr),
                      .data(req.data),
                      .id(req.tg_addr),
                      .rw_(req.rw_));
      end_tr(req);
      `uvm_info(get_type_name(), "Packet sent", UVM_HIGH)
      seq_item_port.item_done();
    end
  endtask

  function void connect_phase(uvm_phase phase); 
    super.connect_phase(phase);
    if (!uvm_config_db#(i2c_proxy)::get(this, "", "bridge_proxy", bridge_proxy))
      `uvm_error("NOPROXY", {"i2c_proxy not set for: ", get_full_name(),".bridge_proxy"})
  endfunction

  function void start_of_simulation_phase(uvm_phase phase);
    `uvm_info(get_type_name(),"Call i2c_driver",UVM_HIGH);
  endfunction
endclass
