// Bridge for analog clock UVC in UVM-AMS

module i2c_bridge import EE_pkg::*; (
  input wire scl_drive, // digital signal from driver
  inout wire sda_drive, // digital signal from driver
  inout EEnet SDA, SCL  // EEnet signals connected to DUT
  );

  //UVM + MS extras
  import uvm_pkg::*;
  import uvm_ms_pkg::*;
  `include "uvm_macros.svh"
  `include "uvm_ms.svh"
  
  //UVM package for this component
  import i2c_pkg::*;

  //Class i2c_bridge_proxy extends the i2c_proxy 
  //The implementation for the push_Vsup function is defined here
  class i2c_bridge_proxy extends i2c_proxy;
    function new(string name = "i2c_bridge_proxy");
      super.new(name);
    endfunction : new
  
    // implementation of function to push Vsup value to analog resource
    virtual function void push_Vsup(input real Vsup);
      core.Vsup  = Vsup;
    endfunction

  endclass
  
  i2c_bridge_proxy proxy = new("proxy");
  //Bridge core instantiation
  i2c_bridge_core core (.sda_drive, .scl_drive, .SDA, .SCL);

endmodule 
