class i2c_agent extends uvm_agent; 
  i2c_monitor monitor;
  i2c_driver driver;
  i2c_sequencer sequencer;

  `uvm_component_utils_begin(i2c_agent)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_ALL_ON)
  `uvm_component_utils_end

  function new(string name="i2c_agent", uvm_component parent); 
    super.new(name, parent);
  endfunction

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
    monitor = i2c_monitor::type_id::create("monitor", this);
    if (is_active == UVM_ACTIVE) begin
        driver = i2c_driver::type_id::create("driver", this);
        sequencer = i2c_sequencer::type_id::create("sequencer", this);
    end
  endfunction

  function void connect_phase(uvm_phase phase); 
    driver.seq_item_port.connect(sequencer.seq_item_export);
  endfunction


  function void start_of_simulation_phase(uvm_phase phase);
    `uvm_info(get_type_name(),"Call i2c_agent",UVM_HIGH)
  endfunction

endclass
