// This *.f file is meant to be run in the xrun_dms_sim directory
-64
-timescale 1ns/1fs
-vtimescale 1ns/1fs
-access +rwc
-define XRUN

// options
-uvm
+UVM_VERBOSITY=UVM_MEDIUM
+UVM_TESTNAME=default_sequence_ms_test

// include directories
-incdir ../../uvc_lib/osc/sv/
-incdir ../../uvc_lib/i2c/sv/
-incdir ../../includes/

// compile files
../../includes/uvm_ms_pkg.sv
../../uvc_lib/osc/sv/osc_pkg.sv
../../uvc_lib/i2c/sv/state_vars_pkg.sv
../../uvc_lib/i2c/sv/i2c_pkg.sv

// Analog resource
// for SVRNM DUT
../../uvc_lib/osc/sv/osc_bridge.sv
../../uvc_lib/osc/sv/osc_bridge_core.sv

// virtual interfaces
../../uvc_lib/osc/sv/osc_if.sv
../../uvc_lib/i2c/sv/i2c_if.sv

// DUT
-incdir ../../src_svrnm/
../../src_svrnm/common_functions.sv
../../src_svrnm/slew.sv
../../src_svrnm/buffer.sv
../../src_svrnm/clk_driver_diff.sv
../../src_svrnm/freq_adapter.sv
../../src_svrnm/freq_div2.sv
../../src_svrnm/freq_doubler.sv
../../src_svrnm/mux4to1.sv
../../src_dig/I2C_target.sv
../../src_dig/I2C_registers.sv

-define UVM_AMS
-incdir ../
../top.sv
-top top
+SVSEED=random

//-coverage U -covoverwrite
//-input probes.tcl
-run -exit

//RNM Coercion is used to change the nettypes of top.{clk_in,clkout_p, clkout_n} from "wire" to "wreal4state"
//This is a Cadence Xcelium Mixed Signal App feature, and for non-Cadence simulators, will need either:
//* an equivalent feature to coercion, OR
//* an update to the ../top.sv and ../../uvc_lib/osc/sv/osc_bridge.sv files
-rnm_coerce detailed


