class freq_adpt_base_test extends uvm_test;

  `uvm_component_utils(freq_adpt_base_test)

  freq_adpt_tb tb;

  function new(string name, uvm_component parent);
    super.new(name,parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
    //Configure the agents
    uvm_config_int::set( this, "tb.freq_generator.agent","is_active", UVM_ACTIVE);
    uvm_config_int::set( this, "tb.freq_detector.agent","is_active", UVM_PASSIVE);
    // Enable transaction recording for everything
    uvm_config_int::set( this, "*", "recording_detail", 1);
    // Create the testbench
    tb = freq_adpt_tb::type_id::create("tb", this);
  endfunction

  function void end_of_elaboration_phase(uvm_phase phase);
    uvm_top.print_topology();
   endfunction

  function void start_of_simulation_phase(uvm_phase phase);
    `uvm_info(get_type_name(), {"start of simulation for ", get_full_name()}, UVM_HIGH);
  endfunction : start_of_simulation_phase

  task run_phase(uvm_phase phase);
  endtask : run_phase

  function void check_phase(uvm_phase phase);
    // configuration checker
    check_config_usage();
  endfunction

endclass : freq_adpt_base_test

//----------------------------------------------------------------
//
// TEST: default_sequence_test - sets the default sequences
//
//----------------------------------------------------------------
class default_sequence_test extends freq_adpt_base_test;
  `uvm_component_utils(default_sequence_test)

  function new(string name, uvm_component parent);
    super.new(name,parent);
  endfunction

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);
    // Set the default sequence for the in_adpt and out_adpt
    uvm_config_wrapper::set(this,"tb.freq_generator.agent.sequencer.run_phase", "default_sequence",osc_nested_seq::get_type());
    uvm_config_wrapper::set(this,"tb.i2c.agent.sequencer.run_phase", "default_sequence",i2c_rdm_mux_seq::get_type());
  endfunction 

endclass

class default_sequence_ms_test extends freq_adpt_base_test;
  `uvm_component_utils(default_sequence_ms_test)

  function new(string name, uvm_component parent);
    super.new(name,parent);
  endfunction

  function void build_phase(uvm_phase phase);
    set_type_override_by_type(freq_adpt_tb::get_type(),freq_adpt_ms_tb::get_type());
    super.build_phase(phase);
    // Set the default sequence for the in_adpt and out_adpt
    uvm_config_wrapper::set(this,"tb.freq_generator.agent.sequencer.run_phase", "default_sequence",osc_ms_nested_seq::get_type());
    uvm_config_wrapper::set(this,"tb.i2c.agent.sequencer.run_phase", "default_sequence",i2c_rdm_mux_seq::get_type());
  endfunction 

endclass
