// A module of frequency doubler

`timescale 1ns/1fs
`ifdef XRUN
import cds_rnm_pkg::*;
`endif
`ifdef VCS
import snps_msv_nettype_pkg::*;
`endif

module freq_doubler(
	clk_out,
	clk_in,
	PW_adj
);

	output wreal4state clk_out;
	input wreal4state clk_in;
	input logic [7:0] PW_adj;
	
  parameter real vsup = 1.8;        //Supply voltage for clock signal (V)
  parameter real vth = vsup/2;      //Threshold voltage for clock signal transition (V)
  parameter real pw_scale = 0.01;   //Scale factor for pulse width adjustment
                                    //1 bit = pw_scale % of output clock duty cycle away from 50%
  
  real Tlast, Tcur;     //internal variables to capture last clock edge time and latest clock edge time
  real clk_outperiod;   //output clock period
  reg clk_outval;
  real clk_outpw;       //output clock positive half-cycle pulse width
  real final_dutycycle; //output clock duty cycle = 50 + pw_scale*pw_adj
  
  initial begin
    Tlast = 0;
    Tcur = 0;
    clk_outval = 0;
  end
  
  //Capture clk_in's half-cycle time on every edge of clk_in
  always @(posedge(clk_in > vth)) begin    
    Tlast = Tcur;
    Tcur = $realtime;
    clk_outperiod = 0.5*(Tcur - Tlast);
    clk_outpw = clk_outperiod * (final_dutycycle) / 100.0; // calculate the pulse width of clk_out
  end
  
  always begin
    wait (Tlast > 0) begin
      clk_outval = 1;  // generate pulse according to the calculated width
      #(clk_outpw);
      clk_outval = 0;
      #(clk_outperiod - clk_outpw);
    end
  end
      
  always begin
    final_dutycycle = $signed(PW_adj)*pw_scale + 50;  
    @(PW_adj);
  end
  
  assign clk_out = clk_outval *vsup;
  
	

endmodule
