// Frequency adapter module

`timescale 1ns/1fs
`ifdef XRUN
import cds_rnm_pkg::*;
`endif

`ifdef VCS
import snps_msv_nettype_pkg::*;
`endif

module frequency_adapter (
  clkout_p,
  clkout_n,
  clk_in,
  en_mux,
  pw_adj,
  sel_mux,
  ampl_adj,
  sr_adj
  );
  
  //Port type declarations
  output wreal4state clkout_p, clkout_n;
  input wreal4state clk_in;
  input logic en_mux;
  input logic [7:0] pw_adj;
  input logic [1:0] sel_mux;
  input logic [1:0] ampl_adj;
  input logic [1:0] sr_adj;
  
  parameter real vsup = 1.8;
  parameter real slewp = 1.8e12; // [unit: V/s]
  parameter real slewn = -1.8e12;
  
  // for ramp generator in mux
  parameter real tr = 1ps; // rising time
  parameter real num_step = 10;
  
  //Internal net declarations
  wreal4state inbuf_out, x1_muxin, x2_muxin, div2_muxin, div4_muxin, muxout;
  
  
  buffer #(.vsup(vsup)) inbuf (.out(inbuf_out), .in(clk_in));
  buffer #(.vsup(vsup)) x1_buf (.out(x1_muxin), .in(inbuf_out));
  
  freq_doubler #(.vsup(vsup)) fx2 (.clk_out(x2_muxin), .clk_in(inbuf_out), .PW_adj(pw_adj));
  
  freq_div2 #(.vsup(vsup)) fdiv2 (.clk_out(div2_muxin), .clk_in(inbuf_out));
  
  freq_div2 #(.vsup(vsup)) fdiv4 (.clk_out(div4_muxin), .clk_in(div2_muxin));
  
  mux4to1 #(.tr(tr), .num_step(num_step),  .vout_max(vsup)) mux (.out(muxout), 
    .in({x2_muxin, x1_muxin, div2_muxin, div4_muxin}), .sel(sel_mux), .en(en_mux));
  
  clk_driver_diff #(.slewp(slewp), .slewn(slewn), .vsup(vsup)) clk_driver (.clkout_p(clkout_p), .clkout_n(clkout_n), 
    .clkin(muxout), .ampl_adj(ampl_adj), .sr_adj(sr_adj));
  
endmodule

