// Digital frequency divider module
`timescale 1ns/1fs

module freq_div2 (
	input logic clk_in,
	output logic clk_out);
	
	reg clk_in_int, clk_out_int;
	
  initial begin
		clk_out_int = 0;
	end
	
	assign clk_in_int = (clk_in === 1'b1) ? 1'b1 : 1'b0;
	
	always @(posedge clk_in_int) begin
			clk_out_int = ~clk_out_int; 
	end
	
	assign clk_out = clk_out_int;
	
endmodule
