// Frequency adapter module

`timescale 1ns/1fs

module frequency_adapter (
  output logic clkout_p, clkout_n,
  input logic clk_in,
  input logic en_mux,
  input logic [7:0] pw_adj,
  input logic [1:0] sel_mux,
  input logic [1:0] ampl_adj,
  input logic [1:0] sr_adj
  );
  
  parameter real vsup = 1.8;
  
  //Internal net declarations
  wire inbuf_out, x1_muxin, x2_muxin, div2_muxin, div4_muxin, muxout;
  
  
  buffer inbuf (.out(inbuf_out), .in(clk_in));
  buffer x1_buf (.out(x1_muxin), .in(inbuf_out));
  
  freq_doubler fx2 (.clk_out(x2_muxin), .clk_in(inbuf_out), .PW_adj(pw_adj));
  
  freq_div2 fdiv2 (.clk_out(div2_muxin), .clk_in(inbuf_out));
  
  freq_div2 fdiv4 (.clk_out(div4_muxin), .clk_in(div2_muxin));
  
  mux4to1 mux (.out(muxout), .in({x2_muxin, x1_muxin, div2_muxin, div4_muxin}), 
    .sel(sel_mux), .en(en_mux));
  
  clk_driver_diff clk_driver (.clkout_p(clkout_p), .clkout_n(clkout_n), .clkin(muxout), 
    .ampl_adj(ampl_adj), .sr_adj(sr_adj));
  
endmodule

