//  Digital model of differential clock driver
//  * Single ended input, differential output

`timescale 1ns/1fs

module clk_driver_diff (
  output logic clkout_p, clkout_n,
  input logic clkin,
  input logic [1:0] ampl_adj, sr_adj //These control signals are not used in the digital model
  );
  
  logic clkin_int;
  
  always_comb begin
    if(^ampl_adj === 1'bx) clkin_int = 1'b0;
    else if (^sr_adj === 1'bx) clkin_int = 1'b0;
    else clkin_int = clkin;
  end
  
  assign clkout_p = clkin_int;
  assign clkout_n = ~clkin_int;

endmodule

